/*
 * videosettings.cpp
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <klocale.h>

#include <tqslider.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqnamespace.h>

#include "videosettings.h"
#include "videosettings.moc"


VideoSettings::VideoSettings(int hue, int sat, int contr, int bright, TQWidget *parent, const char *name)
         : KDialogBase(KDialogBase::Plain, i18n("Video Settings"), KDialogBase::Default | KDialogBase::Close, KDialogBase::Close, parent, name, false)
{
  setInitialSize(TQSize(450,200), true);
  TQWidget* page = plainPage();

  TQGridLayout* grid = new TQGridLayout(page, 4, 2);
  grid->setSpacing(5);

  TQLabel* hueText = new TQLabel(i18n("Hue"), page);
  hueText->setAlignment(AlignRight);
  m_hueSlider = new TQSlider(Qt::Horizontal, page);
  m_hueSlider->setRange(-1000, 1000);
  m_hueSlider->setSteps(10, 100);
  m_hueSlider->setValue(hue);
  connect(m_hueSlider, TQT_SIGNAL(valueChanged(int)), this, TQT_SIGNAL(signalNewHue(int)));
  grid->addWidget(hueText, 0, 0);
  grid->addWidget(m_hueSlider, 0, 1);

  TQLabel* satText = new TQLabel(i18n("Saturation"), page);
  satText->setAlignment(AlignRight);
  m_satSlider = new TQSlider(Qt::Horizontal, page);
  m_satSlider->setRange(-1000, 1000);
  m_satSlider->setSteps(10, 100);
  m_satSlider->setValue(sat);
  connect(m_satSlider, TQT_SIGNAL(valueChanged(int)), this, TQT_SIGNAL(signalNewSaturation(int)));
  grid->addWidget(satText, 1, 0);
  grid->addWidget(m_satSlider, 1, 1);

  TQLabel* contrastText = new TQLabel(i18n("Contrast"), page);
  contrastText->setAlignment(AlignRight);
  m_contrastSlider = new TQSlider(Qt::Horizontal, page);
  m_contrastSlider->setRange(-1000, 1000);
  m_contrastSlider->setSteps(10, 100);
  m_contrastSlider->setValue(contr);
  connect(m_contrastSlider, TQT_SIGNAL(valueChanged(int)), this, TQT_SIGNAL(signalNewContrast(int)));
  grid->addWidget(contrastText, 2, 0);
  grid->addWidget(m_contrastSlider, 2, 1);

  TQLabel* brightText = new TQLabel(i18n("Brightness"), page);
  brightText->setAlignment(AlignRight);
  m_brightSlider = new TQSlider(Qt::Horizontal, page);
  m_brightSlider->setRange(-1000, 1000);
  m_brightSlider->setSteps(10, 100);
  m_brightSlider->setValue(bright);
  connect(m_brightSlider, TQT_SIGNAL(valueChanged(int)), this, TQT_SIGNAL(signalNewBrightness(int)));
  grid->addWidget(brightText, 3, 0);
  grid->addWidget(m_brightSlider, 3, 1);

  connect(this, TQT_SIGNAL(defaultClicked()), this, TQT_SLOT(slotSetDefaultValues()));
}

VideoSettings::~VideoSettings()
{

}

void VideoSettings::slotSetDefaultValues()
{
  m_hueSlider->setValue(1000);
  m_satSlider->setValue(0);
  m_contrastSlider->setValue(0);
  m_brightSlider->setValue(0);
}
