/*
 * kmultitabbar_p.h
 *
 * Copyright (C) 2003 Joseph Wenninger <jowenn@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef KMULTITABBAR_P_H
#define KMULTITABBAR_P_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqscrollview.h>
#include <kmultitabbar.h>

class KMultiTabBarInternal: public TQScrollView
{
        Q_OBJECT
  TQ_OBJECT
public:
        KMultiTabBarInternal(TQWidget *parent,KMultiTabBar::KMultiTabBarMode bm);
        int appendTab(const TQPixmap &,int=-1,const TQString& =TQString());
        KMultiTabBarTab *tab(int) const;
        void removeTab(int);
        void setPosition(enum KMultiTabBar::KMultiTabBarPosition pos);
        void setStyle(enum KMultiTabBar::KMultiTabBarStyle style);
        void showActiveTabTexts(bool show);
        TQPtrList<KMultiTabBarTab>* tabs(){return &m_tabs;}
private:
        friend class KMultiTabBar;
        TQWidget *box;
	TQBoxLayout *mainLayout;
        TQPtrList<KMultiTabBarTab> m_tabs;
        enum KMultiTabBar::KMultiTabBarPosition m_position;
        bool m_showActiveTabTexts;
        enum  KMultiTabBar::KMultiTabBarStyle m_style;
	int m_expandedTabSize;
	int m_lines;
	KMultiTabBar::KMultiTabBarMode m_barMode;
protected:
	virtual bool eventFilter(TQObject *,TQEvent*);
        virtual void drawContents ( TQPainter *, int, int, int, int);

        /**
         * [contentsM|m]ousePressEvent are reimplemented from TQScrollView
         * in order to ignore all mouseEvents on the viewport, so that the
         * parent can handle them.
         */
        virtual void contentsMousePressEvent(TQMouseEvent *);
        virtual void mousePressEvent(TQMouseEvent *);
	virtual void resizeEvent(TQResizeEvent *);
};

#endif /* KMULTITABBAR_P_H */
