/*
 * kaffeinedvbevents.h
 *
 * Copyright (C) 2003-2007 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef KAFFEINEDVBEVENTS_H
#define KAFFEINEDVBEVENTS_H

#include <tqtimer.h>
#include <tqmutex.h>
#include <tqfile.h>
#include <tqobject.h>

#include <kparts/part.h>

#include "kaffeinedvbsection.h"



class ShortEvent
{

public:

	ShortEvent();
	~ShortEvent();

	TQString name;
	TQString text;
};

class EventDesc
{

public:

	EventDesc();
	~EventDesc();

	TQString source;
	unsigned char tid;
	unsigned short sid;
	unsigned short tsid;
	unsigned short nid;
	unsigned char sn;
	unsigned char lsn;
	unsigned short eid;
	unsigned char running;
	TQDateTime startDateTime;
	TQTime duration;
	TQPtrList<ShortEvent> shortEvents;
	TQPtrList<TQString> extEvents;
	TQString title;
	TQString subtitle;
	unsigned int loop;
};



class EventSid
{
public:
	EventSid( int s );
	~EventSid();
	int getSid() { return sid; }
	void lock() { mutex.lock(); }
	void unlock() { mutex.unlock(); }
	TQPtrList<EventDesc> *getEvents() { return &events; }
	EventDesc *getEventDesc( int n );
	int getNDesc() { return events.count(); }
	void remove( EventDesc *d );
private:
	TQMutex mutex;
	int sid;
	TQPtrList<EventDesc> events;
};



class EventTsid
{
public:
	EventTsid( int n, int t );
	~EventTsid();
	int getTsid() { return tsid; }
	int getNid() { return nid; }
	EventSid *getEventSid( int sid );
	EventSid *getNEventSid( int n );
	int getNSid() { return sidList.count(); }
	EventDesc *getEventDesc( int sid, int n );
private:
	TQMutex mutex;
	int tsid, nid;
	TQPtrList<EventSid> sidList;
};



class EventSource
{
public:
	EventSource( TQString src );
	~EventSource();
	EventSid *getEventSid( int nid, int tsid, int sid );
	EventTsid *getNEventTsid( int n );
	int getNTsid() { return tsidList.count(); }
	EventDesc *getEventDesc( int nid, int tsid, int sid, int n );
	TQString getSource() { return source; }
private:
	TQMutex mutex;
	TQString source;
	TQPtrList<EventTsid> tsidList;
};



class EventTable : public TQObject, public TQThread
{
	Q_OBJECT
  TQ_OBJECT
public:
	EventTable();
	~EventTable();
	EventSource *getEventSource( TQString src );
	EventDesc *getEventDesc( TQString src, int nid, int tsid, int sid, int n );
	EventSource *getNEventSource( int n );
	int getNSource() { return srcList.count(); }
	void doClean( bool b );
	void saveEpg();
	void loadEpg();
protected:
	virtual void run();
private:
	bool validString( TQFile &f, EventDesc *d, int len, int buflen, int nev );
	TQMutex mutex;
	TQPtrList<EventSource> srcList;
	TQTimer cleanTimer;
	bool epgLoaded;
private slots:
	void setClean();
};



class KDE_EXPORT KaffeineEpgPlugin : public KParts::Part,  public KaffeineDVBsection
{
	Q_OBJECT
  TQ_OBJECT
public:
	KaffeineEpgPlugin( TQObject* parent, const char* name );
	virtual ~KaffeineEpgPlugin();
	virtual bool go( TQString /*src*/, int /*freqKhz*/ ) { return false; }
	virtual void stop() {}
	void setTable( EventTable *table ) { events = table; }

protected:
	bool safeLen( unsigned char* buf );

	unsigned char secbuf[4096];
	int readSize;
	EventTable *events;
};

#endif /* KAFFEINEDVBEVENTS_H */
