/*
 * ktimereditor.h
 *
 * Copyright (C) 2004-2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef KTIMEREDITOR_H
#define KTIMEREDITOR_H

#include <tqdialog.h>
#include <tqcombobox.h>
#include <tqlineedit.h>
#include <tqdatetimeedit.h>
#include <tqlabel.h>

#include <kpushbutton.h>

#include "channeldesc.h"
#include "gdvb.h"
#include "crontimer.h"



class KTimerEditor : public TQDialog
{
	Q_OBJECT
  TQ_OBJECT

public:

	KTimerEditor( bool newone, TQStringList &chanList, RecTimer t, TQWidget *parent );
	~KTimerEditor();

	KPushButton *okBtn, *cancelBtn, *repeatBtn;
	TQLabel *repeatLab;
	TQLineEdit *nameLe;
	TQComboBox *channelComb;
	TQDateTimeEdit *begin, *end;
	TQTimeEdit *duration;
	RecTimer timer;

public slots:

	void setRepeat();

protected slots:

	virtual void accept();
	void setDuration( const TQDateTime &dt );
	void setEnd( const TQTime &t );
	void setMaxEnd( const TQDateTime &dt );
};

#endif /* KTIMEREDITOR_H */
