/*
 * broadcasteditor.h
 *
 * Copyright (C) 2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef BROADCASTEDITOR_H
#define BROADCASTEDITOR_H

#include <tqpixmap.h>
#include <tqfile.h>
#include <tqlistbox.h>

#include "broadcasteditorui.h"
#include "channeldesc.h"

class BroadcastEditor : public BroadcastEditorUI
{
	Q_OBJECT
  TQ_OBJECT

public:

	BroadcastEditor( TQWidget *parent, TQPtrList<ChannelDesc> *ch, TQPtrList<ChannelDesc> *ret );
	~BroadcastEditor();

	TQPtrList<ChannelDesc> *chan;
	TQPtrList<ChannelDesc> *list;

public slots:

	virtual void addToList();
	virtual void resetList();
	void slotAddChannel(TQListBoxItem*);

private:

	bool getChannelList();
	ChannelDesc* getChannel( const TQString &name );

	TQPixmap tvPix, raPix, tvcPix, racPix;

};

#endif /* BROADCASTEDITOR_H */
