/*
 * googlefetcherdialog.h
 *
 * Copyright (C) 2004 Nathan Toone <nathan@toonetown.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef GOOGLEFETCHERDIALOG_H
#define GOOGLEFETCHERDIALOG_H

#include <kiconview.h>
#include <kio/job.h>

#include "googlefetcher.h"

class KURL;

class GoogleFetcherDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    GoogleFetcherDialog(const TQString &name,
                        const GoogleImageList &urlList,
                        const TQString &artist,
                        const TQString &album,
                        TQWidget *parent = 0);

    virtual ~GoogleFetcherDialog();

    TQPixmap result() const { return m_pixmap; }
    bool takeIt() const { return m_takeIt; }
    bool newSearch() const { return m_newSearch; }

    void setLayout();
    void setImageList(const GoogleImageList &urlList);

public slots:
    int exec();
    void refreshScreen(GoogleImageList &list);

signals:
    void sizeChanged(GoogleFetcher::ImageSize);

protected slots:
    void slotOk();
    void slotCancel();
    void slotUser1();
    void imgSizeChanged(int index);

private:
    TQPixmap fetchedImage(uint index) const;
    TQPixmap pixmapFromURL(const KURL &url) const;

    TQPixmap m_pixmap;
    GoogleImageList m_imageList;
    KIconView *m_iconWidget;
    bool m_takeIt;
    bool m_newSearch;
    TQString m_artist, m_album;
};

namespace KIO
{
    class TransferJob;
}

class CoverIconViewItem : public TQObject, public KIconViewItem
{
    Q_OBJECT
  TQ_OBJECT

public:
    CoverIconViewItem(TQIconView *parent, const GoogleImage &image);
    ~CoverIconViewItem();

private slots:
    void imageData(KIO::Job *job, const TQByteArray &data);
    void imageResult(KIO::Job* job);

private:
    TQByteArray m_buffer;
    TQGuardedPtr<KIO::TransferJob> m_job;
};

#endif /* GOOGLEFETCHERDIALOG_H */
