//
// C++ Interface:
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef K9MENUEDIT_H
#define K9MENUEDIT_H

#include "../k9author/menuEdit.h"
#include <tqcanvas.h>
#include <tqimage.h>

class k9MenuButton;
class k9MenuEdit;
class k9Title;
class k9NewDVD;
class k9MenuEditor;


class k9MenuEdit : public menuEdit {
    Q_OBJECT
  TQ_OBJECT
public:
    enum eFormat {PAL=1,NTSC=2};
    enum eMenuType {ROOTMENU,TITLEMENU};

    k9MenuEdit(TQWidget* parent = 0, const char* name = 0,TQCanvas *_canvas=0);
    ~k9MenuEdit();
    /*$PUBLIC_FUNCTIONS$*/
    void setBackgroundImage(const TQImage &_image);
    void setText(const TQString &_value);
    void setFont(const TQFont &_value);
    void setColor(const TQColor &_value);
    void updateTextPos(const TQPoint &_point);
public slots:
    /*$PUBLIC_SLOTS$*/
    void itemSelected();
    TQCanvasText* getText() const;
    void setFormat(const eFormat& _value);
    k9MenuEdit::eFormat getFormat() const;
    TQCanvas *getCanvas();
    void setCanvas(TQCanvas* _value);
    void titleSelected(k9Title *);
    void rootSelected(k9NewDVD *);

protected:
    /*$PROTECTED_FUNCTIONS$*/
    virtual void bFontClick();
    virtual void urBackgroundSelected(const TQString &_fileName);
    virtual void cbColorChanged(const TQColor &_color);
    virtual void leTitleChanged(const TQString &_value);
    virtual void cbPosTitleActivated(int _value);
    virtual void bAddTextClick();
    virtual void cbStartActivated (int _value); 
    virtual void cbEndActivated (int _value);
    k9MenuEditor *m_menuEditor;
    TQCanvas *m_canvas;
    TQImage m_background;
    TQCanvasText *m_text;
    eFormat m_format;
    int m_imageHeight;
    eMenuType m_menuType;
    TQStringList m_startScripts;
    TQStringList m_endScripts;
    bool m_noUpdate;
protected slots:
    /*$PROTECTED_SLOTS$*/
signals:
    void backgroundImageChanged(const TQImage &);
    void textChanged(const TQString&);
    void startScriptChanged(const TQString&);
    void endScriptChanged(const TQString&);
    void textColorChanged(const TQColor &);
    void textFontChanged(const TQFont&);
    void updatePos(const TQPoint &);
};

#endif

