/* 
 *
 * $Id: k3baudiooutputplugin.h 619556 2007-01-03 17:38:12Z trueg $
 * Copyright (C) 2004 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2007 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef _K3B_AUDIO_OUTPUTPLUGIN_H_
#define _K3B_AUDIO_OUTPUTPLUGIN_H_

#include <k3bplugin.h>
#include "k3b_export.h"

/**
 *
 */
class LIBK3B_EXPORT K3bAudioOutputPlugin : public K3bPlugin
{
  Q_OBJECT
  TQ_OBJECT

 public:
  virtual ~K3bAudioOutputPlugin() {
  }

  TQString group() const { return "AudioOutput"; }

  /**
   * This is the short name of the sound system which can be used
   * to specify the sound system on the command line (like "arts", "alsa", or "oss")
   */
  virtual TQCString soundSystem() const = 0;

  /**
   * Initialize the plugin.
   *
   * Return true on success.
   * In case of a failure report the error through lastErrorMessage
   */
  virtual bool init() { return true; }

  /**
   * Cleanup the plugin. This is the counterpart to init()
   */
  virtual void cleanup() {}

  virtual TQString lastErrorMessage() const { return TQString(); }

  /**
   * Let there be sound...
   *
   * @returns number of written bytes or -1 on error.
   */
  virtual int write( char* data, int len ) = 0;

 protected:
  K3bAudioOutputPlugin( TQObject* parent = 0, const char* name = 0 )
    : K3bPlugin( parent, name ) {
  }
};

#endif
