// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for KDE
Copyright 2006 Aurélien Gâteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef IMAGEVIEWCONTROLLER_H
#define IMAGEVIEWCONTROLLER_H   

// TQt
#include <tqobject.h>

// KDE
#include <kaction.h>

// Local
#include "libgwenview_export.h"

class TQPoint;
class TQWidget;

class KToolBar;

namespace Gwenview {


class Document;
class ImageView;


class LIBGWENVIEW_EXPORT ImageViewController : public TQObject {
Q_OBJECT
  TQ_OBJECT
public:
	ImageViewController(TQWidget* parent, Document*, KActionCollection*);
	~ImageViewController();
	
	TQWidget* widget() const;
	
	void setImageViewActions(const KActionPtrList&);

	void setFullScreen(bool);
	void setNormalCommonActions(const KActionPtrList&);
	void setFullScreenCommonActions(const KActionPtrList&);
	void setFocus();

protected:
	virtual bool eventFilter(TQObject*, TQEvent*);

public slots:
	void updateFromSettings();

signals:
	void requestHintDisplay(const TQString&);
	void selectPrevious();
	void selectNext();
	void doubleClicked();

private slots:
	void slotLoaded();
	void openImageViewContextMenu(const TQPoint&);
	void slotAutoHide();

private:
	struct Private;
	Private* d;
};

} // namespace

#endif /* IMAGEVIEWCONTROLLER_H */
