// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for KDE
Copyright 2000-2004 Aurlien Gteau
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef EXTERNALTOOLCONTEXT_H
#define EXTERNALTOOLCONTEXT_H

// STL
#include <list>

// TQt
#include <tqobject.h>

// KDE
#include <kurl.h>

// Local
#include "libgwenview_export.h"

class TQPopupMenu;
class KService;

namespace Gwenview {
class LIBGWENVIEW_EXPORT ExternalToolContext : public TQObject {
Q_OBJECT
  TQ_OBJECT
public:
	ExternalToolContext(TQObject* parent,
		std::list<KService*> services,
		KURL::List urls);
	TQPopupMenu* popupMenu();

private slots:
	void showExternalToolDialog();
	void showOpenWithDialog();

private:
	std::list<KService*> mServices;
	KURL::List mURLs;
};

} // namespace
#endif

