// vim: set tabstop=4 shiftwidth=4 noexpandtab:
/*
Gwenview - A simple image viewer for KDE
Copyright 2000-2004 Aur�ien G�eau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "cursortracker.h"

// TQt
#include <tqevent.h>
#include <tqtooltip.h>

namespace Gwenview {

CursorTracker::CursorTracker(const TQString& txt, TQWidget* reference)
: TQLabel(txt, 0, "", WX11BypassWM) {
	reference->setMouseTracking(true);
	reference->installEventFilter(this);
}


/**
 * Overload to make sure the widget size is correct
 */
void CursorTracker::setText(const TQString& txt) {
	TQLabel::setText(txt);
	adjustSize();
}


bool CursorTracker::eventFilter(TQObject* object, TQEvent* _event) {
	TQWidget* widget=TQT_TQWIDGET(object);
	
	switch (_event->type()) {
	case TQEvent::MouseMove: {
		TQMouseEvent* event=TQT_TQMOUSEEVENT(_event);
		if (TQT_TQRECT_OBJECT(widget->rect()).contains(event->pos()) || (event->stateAfter() & Qt::LeftButton)) {
			show();
			move(event->globalPos().x() + 15, event->globalPos().y() + 15);
		} else {
			hide();
		}
		break;
	}

	case TQEvent::MouseButtonRelease: {
		TQMouseEvent* event=TQT_TQMOUSEEVENT(_event);
		if ( !TQT_TQRECT_OBJECT(widget->rect()).contains(event->pos()) ) {
			hide();
		}
		break;
	}
	
	default:
		break;
	}

	return false;
}


TipTracker::TipTracker(const TQString& txt, TQWidget* reference)
: CursorTracker(txt, reference) {
	setPalette(TQToolTip::palette());
	setFrameStyle(TQFrame::Plain | TQFrame::Box);
	setLineWidth(1);
	setAlignment(AlignAuto | AlignTop);
}
	

} // namespace
