// vim: set tabstop=4 shiftwidth=4 noexpandtab:
/*
Gwenview - A simple image viewer for KDE
Copyright 2005 Aurelien Gateau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef BOOKMARKVIEWCONTROLLER_H
#define BOOKMARKVIEWCONTROLLER_H

// TQt
#include <tqobject.h>

// KDE
#include <klistview.h>
#include <kurl.h>

class TQDragMoveEvent;
class TQDropEvent;
class TQListViewItem;
class TQPoint;
class KBookmarkManager;
class KURL;

namespace Gwenview {

	
/**
 * A listview on which the user can drop urls
 */
class URLDropListView : public KListView {
Q_OBJECT
  TQ_OBJECT
public:
	URLDropListView(TQWidget* parent);

signals:
	void urlDropped(TQDropEvent*, const KURL::List&);
	
protected:
	virtual void contentsDragMoveEvent(TQDragMoveEvent* event);
	virtual void contentsDropEvent(TQDropEvent* event);
};


class BookmarkViewController : public TQObject {
Q_OBJECT
  TQ_OBJECT
public:
	BookmarkViewController(TQWidget*);
	~BookmarkViewController();

	void init(KBookmarkManager*);

	TQWidget* widget() const;
	
signals:
	void openURL(const KURL&);

public slots:
	void setURL(const KURL&);

private slots:
	void slotOpenBookmark(TQListViewItem*);
	void fill();
	void slotContextMenu(TQListViewItem*);
	void slotURLDropped(TQDropEvent*, const KURL::List&);
	void slotBookmarkDroppedURL();
	void bookmarkCurrentURL();
	void addBookmarkGroup();
	void editCurrentBookmark();
	void deleteCurrentBookmark();

private:
	struct Private;
	Private* d;
};


} // namespace
#endif

