//Author:    Max Howell <max.howell@methylblue.com>, (C) 2003-4
//Copyright: See COPYING file that comes with this distribution

#include <kglobal.h>
#include <kglobalsettings.h>
#include <kio/job.h>
#include <klocale.h>

#include "scan.h"
#include "progressBox.h"


ProgressBox::ProgressBox( TQWidget *parent, TQObject *part )
   : TQLabel( parent, "ProgressBox" )
{
   hide();

   setAlignment( TQt::AlignCenter );
   setFont( KGlobalSettings::fixedFont() );
   setSizePolicy( TQSizePolicy::Minimum, TQSizePolicy::Fixed );

   setText( 999999 );
   setMinimumWidth( sizeHint().width() );

   connect( &m_timer, TQT_SIGNAL(timeout()), TQT_SLOT(report()) );
   connect( part, TQT_SIGNAL(started( KIO::Job* )), TQT_SLOT(start()) );
   connect( part, TQT_SIGNAL(completed()), TQT_SLOT(stop()) );
   connect( part, TQT_SIGNAL(canceled( const TQString& )), TQT_SLOT(halt()) );
}

void
ProgressBox::start() //slot
{
   m_timer.start( 50 ); //20 times per second - very smooth
   report();
   show();
}

void
ProgressBox::report() //slot
{
   setText( Filelight::ScanManager::files() );
}

void
ProgressBox::stop()
{
   m_timer.stop();
}

void
ProgressBox::halt()
{
   // canceled by stop button
   m_timer.stop();
   TQTimer::singleShot( 2000, this, TQT_SLOT(hide()) );
}

void
ProgressBox::setText( int files )
{
   TQLabel::setText( i18n("%n File", "%n Files", files) );
}

#include "progressBox.moc"
