/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz                                      *
 *   peter.penz@gmx.at                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "editbookmarkdialog.h"
#include <tqgrid.h>
#include <klocale.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <kiconloader.h>
#include <tqpushbutton.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <kicondialog.h>
#include <tqhbox.h>

EditBookmarkDialog::~EditBookmarkDialog()
{
}

KBookmark EditBookmarkDialog::getBookmark(const TQString& title,
                                          const TQString& name,
                                          const KURL& url,
                                          const TQString& icon)
{
    EditBookmarkDialog dialog(title, name, url, icon);
    dialog.exec();
    return dialog.m_bookmark;
}

void EditBookmarkDialog::slotOk()
{
    m_bookmark = KBookmark::standaloneBookmark(m_name->text(),
                                               KURL(m_location->text()),
                                               m_iconName);

    KDialogBase::slotOk();
}

EditBookmarkDialog::EditBookmarkDialog(const TQString& title,
                                       const TQString& name,
                                       const KURL& url,
                                       const TQString& icon) :
    KDialogBase(Plain, title, Ok|Cancel, Ok),
    m_iconButton(0),
    m_name(0),
    m_location(0)
{
    TQVBoxLayout* topLayout = new TQVBoxLayout(plainPage(), 0, spacingHint());

    TQGrid* grid = new TQGrid(2, Qt::Horizontal, plainPage());
    grid->setSpacing(spacingHint());

    // create icon widgets
    new TQLabel(i18n("Icon:"), grid);
    m_iconName = icon;
    m_iconButton = new TQPushButton(SmallIcon(m_iconName), TQString(), grid);
    m_iconButton->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    connect(m_iconButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(selectIcon()));

    // create name widgets
    new TQLabel(i18n("Name:"), grid);
    m_name = new TQLineEdit(name, grid);
    m_name->selectAll();
    m_name->setFocus();

    // create location widgets
    new TQLabel(i18n("Location:"), grid);

    TQHBox* locationBox = new TQHBox(grid);
    locationBox->setSizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Fixed);
    locationBox->setSpacing(spacingHint());
    m_location = new TQLineEdit(url.prettyURL(), locationBox);
    m_location->setMinimumWidth(320);

    TQPushButton* selectLocationButton = new TQPushButton(SmallIcon("folder"), TQString(), locationBox);
    selectLocationButton->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    connect(selectLocationButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(selectLocation()));

    topLayout->addWidget(grid);
}

void EditBookmarkDialog::selectIcon()
{
    const TQString iconName(KIconDialog::getIcon(KIcon::Small, KIcon::FileSystem));
    if (!iconName.isEmpty()) {
        m_iconName = iconName;
        m_iconButton->setIconSet(SmallIcon(iconName));
    }
}

void EditBookmarkDialog::selectLocation()
{
    const TQString location(m_location->text());
    KURL url(KFileDialog::getExistingURL(location));
    if (!url.isEmpty()) {
        m_location->setText(url.prettyURL());
    }
}

#include "editbookmarkdialog.moc"
