/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2006-07-09
 * Description : album item tool tip configuration setup tab
 *
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqlayout.h>
#include <tqvgroupbox.h>
#include <tqcheckbox.h>
#include <tqwhatsthis.h>

// KDE includes.

#include <klocale.h>
#include <kdialogbase.h>

// Local includes.

#include "albumsettings.h"
#include "setuptooltip.h"
#include "setuptooltip.moc"

namespace Digikam
{

class SetupToolTipPriv
{
public:

    SetupToolTipPriv()
    {
        showToolTipsBox   = 0;

        showFileNameBox   = 0;
        showFileDateBox   = 0;
        showFileSizeBox   = 0;
        showImageTypeBox  = 0;
        showImageDimBox   = 0;

        showPhotoMakeBox  = 0;
        showPhotoDateBox  = 0;
        showPhotoFocalBox = 0;
        showPhotoExpoBox  = 0;
        showPhotoModeBox  = 0;
        showPhotoFlashBox = 0;
        showPhotoWbBox    = 0;

        showAlbumNameBox  = 0;
        showCommentsBox   = 0;
        showTagsBox       = 0;
        showRatingBox     = 0;

        fileSettingBox    = 0;
        photoSettingBox   = 0;
        digikamSettingBox = 0;
    }

    TQCheckBox  *showToolTipsBox;

    TQCheckBox  *showFileNameBox;
    TQCheckBox  *showFileDateBox;
    TQCheckBox  *showFileSizeBox;
    TQCheckBox  *showImageTypeBox;
    TQCheckBox  *showImageDimBox;

    TQCheckBox  *showPhotoMakeBox;
    TQCheckBox  *showPhotoDateBox;
    TQCheckBox  *showPhotoFocalBox;
    TQCheckBox  *showPhotoExpoBox;
    TQCheckBox  *showPhotoModeBox;
    TQCheckBox  *showPhotoFlashBox;
    TQCheckBox  *showPhotoWbBox;

    TQCheckBox  *showAlbumNameBox;
    TQCheckBox  *showCommentsBox;
    TQCheckBox  *showTagsBox;
    TQCheckBox  *showRatingBox;

    TQVGroupBox *fileSettingBox;
    TQVGroupBox *photoSettingBox;
    TQVGroupBox *digikamSettingBox;
};

SetupToolTip::SetupToolTip(TQWidget* parent)
            : TQWidget(parent)
{
    d = new SetupToolTipPriv;
    TQVBoxLayout *layout = new TQVBoxLayout( parent, 0, KDialog::spacingHint() );

    d->showToolTipsBox = new TQCheckBox(i18n("Show album items toolti&ps"), parent);
    TQWhatsThis::add( d->showToolTipsBox, i18n("<p>Set this option to display image information when "
                                              "the mouse hovers over an album item."));

    layout->addWidget(d->showToolTipsBox);

    // --------------------------------------------------------

    d->fileSettingBox = new TQVGroupBox(i18n("File/Image Information"), parent);

    d->showFileNameBox = new TQCheckBox(i18n("Show file name"), d->fileSettingBox);
    TQWhatsThis::add( d->showFileNameBox, i18n("<p>Set this option to display the image file name."));

    d->showFileDateBox = new TQCheckBox(i18n("Show file date"), d->fileSettingBox);
    TQWhatsThis::add( d->showFileDateBox, i18n("<p>Set this option to display the image file date."));

    d->showFileSizeBox = new TQCheckBox(i18n("Show file size"), d->fileSettingBox);
    TQWhatsThis::add( d->showFileSizeBox, i18n("<p>Set this option to display the image file size."));

    d->showImageTypeBox = new TQCheckBox(i18n("Show image type"), d->fileSettingBox);
    TQWhatsThis::add( d->showImageTypeBox, i18n("<p>Set this option to display the image type."));

    d->showImageDimBox = new TQCheckBox(i18n("Show image dimensions"), d->fileSettingBox);
    TQWhatsThis::add( d->showImageDimBox, i18n("<p>Set this option to display the image dimensions in pixels."));

    layout->addWidget(d->fileSettingBox);

    // --------------------------------------------------------

    d->photoSettingBox = new TQVGroupBox(i18n("Photograph Information"), parent);

    d->showPhotoMakeBox = new TQCheckBox(i18n("Show camera make and model"), d->photoSettingBox);
    TQWhatsThis::add( d->showPhotoMakeBox, i18n("<p>Set this option to display the make and model of the "
                                               "camera with which the image has been taken."));

    d->showPhotoDateBox = new TQCheckBox(i18n("Show camera date"), d->photoSettingBox);
    TQWhatsThis::add( d->showPhotoDateBox, i18n("<p>Set this option to display the date when the image was taken."));

    d->showPhotoFocalBox = new TQCheckBox(i18n("Show camera aperture and focal"), d->photoSettingBox);
    TQWhatsThis::add( d->showPhotoFocalBox, i18n("<p>Set this option to display the camera aperture and focal settings "
                     "used to take the image."));

    d->showPhotoExpoBox = new TQCheckBox(i18n("Show camera exposure and sensitivity"), d->photoSettingBox);
    TQWhatsThis::add( d->showPhotoExpoBox, i18n("<p>Set this option to display the camera exposure and sensitivity "
                     "used to take the image."));

    d->showPhotoModeBox = new TQCheckBox(i18n("Show camera mode and program"), d->photoSettingBox);
    TQWhatsThis::add( d->showPhotoModeBox, i18n("<p>Set this option to display the camera mode and program "
                     "used to take the image."));

    d->showPhotoFlashBox = new TQCheckBox(i18n("Show camera flash settings"), d->photoSettingBox);
    TQWhatsThis::add( d->showPhotoFlashBox, i18n("<p>Set this option to display the camera flash settings "
                     "used to take the image."));

    d->showPhotoWbBox = new TQCheckBox(i18n("Show camera white balance settings"), d->photoSettingBox);
    TQWhatsThis::add( d->showPhotoWbBox, i18n("<p>Set this option to display the camera white balance settings "
                     "used to take the image."));

    layout->addWidget(d->photoSettingBox);

    // --------------------------------------------------------

    d->digikamSettingBox = new TQVGroupBox(i18n("digiKam Information"), parent);

    d->showAlbumNameBox = new TQCheckBox(i18n("Show album name"), d->digikamSettingBox);
    TQWhatsThis::add( d->showAlbumNameBox, i18n("<p>Set this option to display the album name."));

    d->showCommentsBox = new TQCheckBox(i18n("Show image caption"), d->digikamSettingBox);
    TQWhatsThis::add( d->showCommentsBox, i18n("<p>Set this option to display the image captions."));

    d->showTagsBox = new TQCheckBox(i18n("Show image tags"), d->digikamSettingBox);
    TQWhatsThis::add( d->showTagsBox, i18n("<p>Set this option to display the image tags."));

    d->showRatingBox = new TQCheckBox(i18n("Show image rating"), d->digikamSettingBox);
    TQWhatsThis::add( d->showRatingBox, i18n("<p>Set this option to display the image rating."));

    layout->addWidget(d->digikamSettingBox);
    layout->addStretch();

    // --------------------------------------------------------

    connect(d->showToolTipsBox, TQT_SIGNAL(toggled(bool)),
            d->fileSettingBox, TQT_SLOT(setEnabled(bool)));

    connect(d->showToolTipsBox, TQT_SIGNAL(toggled(bool)),
            d->photoSettingBox, TQT_SLOT(setEnabled(bool)));

    connect(d->showToolTipsBox, TQT_SIGNAL(toggled(bool)),
            d->digikamSettingBox, TQT_SLOT(setEnabled(bool)));

    // --------------------------------------------------------

    readSettings();
    adjustSize();
}

SetupToolTip::~SetupToolTip()
{
    delete d;
}

void SetupToolTip::applySettings()
{
    AlbumSettings* settings = AlbumSettings::instance();
    if (!settings) return;

    settings->setShowToolTips(d->showToolTipsBox->isChecked());

    settings->setToolTipsShowFileName(d->showFileNameBox->isChecked());
    settings->setToolTipsShowFileDate(d->showFileDateBox->isChecked());
    settings->setToolTipsShowFileSize(d->showFileSizeBox->isChecked());
    settings->setToolTipsShowImageType(d->showImageTypeBox->isChecked());
    settings->setToolTipsShowImageDim(d->showImageDimBox->isChecked());

    settings->setToolTipsShowPhotoMake(d->showPhotoMakeBox->isChecked());
    settings->setToolTipsShowPhotoDate(d->showPhotoDateBox->isChecked());
    settings->setToolTipsShowPhotoFocal(d->showPhotoFocalBox->isChecked());
    settings->setToolTipsShowPhotoExpo(d->showPhotoExpoBox->isChecked());
    settings->setToolTipsShowPhotoMode(d->showPhotoModeBox->isChecked());
    settings->setToolTipsShowPhotoFlash(d->showPhotoFlashBox->isChecked());
    settings->setToolTipsShowPhotoWB(d->showPhotoWbBox->isChecked());

    settings->setToolTipsShowAlbumName(d->showAlbumNameBox->isChecked());
    settings->setToolTipsShowComments(d->showCommentsBox->isChecked());
    settings->setToolTipsShowTags(d->showTagsBox->isChecked());
    settings->setToolTipsShowRating(d->showRatingBox->isChecked());

    settings->saveSettings();
}

void SetupToolTip::readSettings()
{
    AlbumSettings* settings = AlbumSettings::instance();

    if (!settings) return;

    d->showToolTipsBox->setChecked(settings->getShowToolTips());

    d->showFileNameBox->setChecked(settings->getToolTipsShowFileName());
    d->showFileDateBox->setChecked(settings->getToolTipsShowFileDate());
    d->showFileSizeBox->setChecked(settings->getToolTipsShowFileSize());
    d->showImageTypeBox->setChecked(settings->getToolTipsShowImageType());
    d->showImageDimBox->setChecked(settings->getToolTipsShowImageDim());

    d->showPhotoMakeBox->setChecked(settings->getToolTipsShowPhotoMake());
    d->showPhotoDateBox->setChecked(settings->getToolTipsShowPhotoDate());
    d->showPhotoFocalBox->setChecked(settings->getToolTipsShowPhotoFocal());
    d->showPhotoExpoBox->setChecked(settings->getToolTipsShowPhotoExpo());
    d->showPhotoModeBox->setChecked(settings->getToolTipsShowPhotoMode());
    d->showPhotoFlashBox->setChecked(settings->getToolTipsShowPhotoFlash());
    d->showPhotoWbBox->setChecked(settings->getToolTipsShowPhotoWB());

    d->showAlbumNameBox->setChecked(settings->getToolTipsShowAlbumName());
    d->showCommentsBox->setChecked(settings->getToolTipsShowComments());
    d->showTagsBox->setChecked(settings->getToolTipsShowTags());
    d->showRatingBox->setChecked(settings->getToolTipsShowRating());

    d->fileSettingBox->setEnabled(d->showToolTipsBox->isChecked());
    d->photoSettingBox->setEnabled(d->showToolTipsBox->isChecked());
    d->digikamSettingBox->setEnabled(d->showToolTipsBox->isChecked());
}

}  // namespace Digikam

