/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-09-17
 * Description : digital camera controller
 *
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2009 by Gilles Caulier <caulier dot gilles at gmail dot com> 
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef CAMERACONTROLLER_H
#define CAMERACONTROLLER_H

// TQt includes.

#include <tqobject.h>
#include <tqstring.h>
#include <tqfileinfo.h>

// Local includes.

#include "downloadsettingscontainer.h"
#include "gpiteminfo.h"

namespace Digikam
{

class CameraControllerPriv;

class CameraController : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

public:

    CameraController(TQWidget* parent, const TQString& title, const TQString& model,
                     const TQString& port, const TQString& path);
    ~CameraController();

    void listFolders();
    void listFiles(const TQString& folder);
    void getThumbnail(const TQString& folder, const TQString& file);
    void getExif(const TQString& folder, const TQString& file);
    void getCameraInformations();
    TQString getCameraPath();
    TQString getCameraTitle();

    void downloadPrep();
    void download(DownloadSettingsContainer downloadSettings);
    void upload(const TQFileInfo& srcFileInfo, const TQString& destFile, const TQString& destFolder);
    void deleteFile(const TQString& folder, const TQString& file);
    void lockFile(const TQString& folder, const TQString& file, bool lock);
    void openFile(const TQString& folder, const TQString& file);

signals:

    void signalBusy(bool val);
    void signalInfoMsg(const TQString& msg);
    void signalErrorMsg(const TQString& msg);
    void signalCameraInformations(const TQString& summary, const TQString& manual, const TQString& about);

    void signalConnected(bool val);
    void signalFolderList(const TQStringList& folderList);
    void signalFileList(const GPItemInfoList& infoList);
    void signalUploaded(const GPItemInfo& itemInfo);
    void signalDownloaded(const TQString& folder, const TQString& file, int status);
    void signalSkipped(const TQString& folder, const TQString& file);
    void signalDeleted(const TQString& folder, const TQString& file, bool status);
    void signalLocked(const TQString& folder, const TQString& file, bool status);
    void signalThumbnail(const TQString& folder, const TQString& file, const TQImage& thumb);
    void signalExifFromFile(const TQString& folder, const TQString& file);
    void signalExifData(const TQByteArray& exifData);

protected:

    void customEvent(TQCustomEvent* e);

public slots:

    void slotCancel();
    void slotConnect();

private slots:

    void slotProcessNext();

private:

    CameraControllerPriv *d;

    friend class CameraThread;
};

}  // namespace Digikam

#endif /* CAMERACONTROLLER_H */
