/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-07-15
 * Description : themed icon view 
 * 
 * Copyright (C) 2005 by Renchi Raju <renchi at pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef THEMEDICONVIEW_H
#define THEMEDICONVIEW_H

// TQt includes.

#include <tqpixmap.h>

// Local includes.

#include "iconview.h"

namespace Digikam
{

class ThemedIconViewPriv;

class ThemedIconView : public IconView
{
    Q_OBJECT
  TQ_OBJECT
    
public:

    ThemedIconView(TQWidget* parent);
    ~ThemedIconView();
    
    TQRect    itemRect() const;
    TQRect    itemDateRect() const;
    TQRect    itemPixmapRect() const;
    TQRect    itemNameRect() const;
    TQRect    itemCommentsRect() const;
    TQRect    itemResolutionRect() const;
    TQRect    itemSizeRect() const;
    TQRect    itemTagRect() const;
    TQRect    bannerRect() const;

    TQPixmap* itemBaseRegPixmap() const;
    TQPixmap* itemBaseSelPixmap() const;
    TQPixmap  bannerPixmap() const;

    TQFont    itemFontReg() const;
    TQFont    itemFontCom() const;
    TQFont    itemFontXtra() const;

protected:

    void resizeEvent(TQResizeEvent* e);
    
private:

    void updateBannerRectPixmap();
    void updateItemRectsPixmap();

    ThemedIconViewPriv* d;
    
private slots:

    void slotThemeChanged();
};

}  // NameSpace Digikam

#endif /* THEMEDICONVIEW_H */
