/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-07-23
 * Description : simple plugins dialog without threadable 
 *               filter interface. The dialog layout is 
 *               designed to accept custom widgets in 
 *               preview and settings area.
 * 
 * Copyright 2005-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef IMAGEDLGBASE_H
#define IMAGEDLGBASE_H

// TQt includes

#include <tqstring.h>

// KDE includes.

#include <kdialogbase.h>

// Local includes.

#include "digikam_export.h"

class TQWidget;

class KAboutData;

namespace Digikam
{

class ImageDlgBasePriv;

class DIGIKAM_EXPORT ImageDlgBase : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:

    ImageDlgBase(TQWidget *parent, TQString title, TQString name, 
                 bool loadFileSettings=true, bool tryAction=false, TQFrame* bannerFrame=0);
    ~ImageDlgBase();

    void setAboutData(KAboutData *about);
    void setPreviewAreaWidget(TQWidget *w);
    void setUserAreaWidget(TQWidget *w);

protected slots:

    virtual void slotDefault();
    virtual void slotTimer();       
    
protected:
    
    void closeEvent(TQCloseEvent *e);
    virtual void finalRendering(){};
    virtual void writeUserSettings(void){};
    virtual void readUserSettings(void){ slotDefault(); };
    virtual void resetValues(void){};

private slots:
    
    void slotHelp();
    void slotCancel();
    void slotOk();        
    virtual void slotEffect(){};

private:

    void readSettings(void);
    void writeSettings(void);
 
private:

    ImageDlgBasePriv* d;
};

}  // NameSpace Digikam

#endif /* IMAGEDLGBASE */
