/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2005-04-21
 * Description : a dio-slave to process file operations on 
 *               digiKam albums.
 *
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * Lots of the file io code is copied from KDE file kioslave.
 * Copyright for the KDE file kioslave follows:
 *  Copyright (C) 2000-2002 Stephan Kulow <coolo@kde.org>
 *  Copyright (C) 2000-2002 David Faure <faure@kde.org>
 *  Copyright (C) 2000-2002 Waldo Bastian <bastian@kde.org>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef DIGIKAMALBUMS_H
#define DIGIKAMALBUMS_H

// TQt includes.

#include <tqvaluelist.h>
#include <tqdatetime.h>
#include <sqlitedb.h>

// KDE includes.

#include <kio/slavebase.h>

class TQStringList;

class AlbumInfo
{
public:

    int      id;
    TQ_LLONG  icon;
    TQString  url;
    TQString  caption;
    TQString  collection;
    TQDate    date;
};        
    
class kio_digikamalbums : public KIO::SlaveBase
{

public:

    kio_digikamalbums(const TQCString &pool_socket,
                      const TQCString &app_socket);
    ~kio_digikamalbums();

    void special(const TQByteArray& data);

    void get( const KURL& url );
    void put( const KURL& url, int _mode, bool _overwrite, bool _resume );
    void copy( const KURL &src, const KURL &dest, int mode, bool overwrite );
    void rename( const KURL &src, const KURL &dest, bool overwrite );

    void stat( const KURL& url );
    void listDir( const KURL& url );
    void mkdir( const KURL& url, int permissions );
    void chmod( const KURL& url, int permissions );
    void del( const KURL& url, bool isfile);         
    
private:

    bool createUDSEntry(const TQString& path, KIO::UDSEntry& entry);
    void createDigikamPropsUDSEntry(KIO::UDSEntry& entry);

    void       buildAlbumList();
    AlbumInfo  findAlbum(const TQString& url, bool addIfNotExists=true);
    void       delAlbum(int albumID);
    void       renameAlbum(const TQString& oldURL, const TQString& newURL);
    bool       findImage(int albumID, const TQString& name) const;
    void       addImage(int albumID, const TQString& filePath);
    void       delImage(int albumID, const TQString& name);
    void       renameImage(int oldAlbumID, const TQString& oldName,
                           int newAlbumID, const TQString& newName);
    void       copyImage(int srcAlbumID, const TQString& srcName,
                         int dstAlbumID, const TQString& dstName);

    void       scanAlbum(const TQString& url);
    void       scanOneAlbum(const TQString& url);
    void       removeInvalidAlbums();
    
private:

    SqliteDB              m_sqlDB;
    TQString               m_libraryPath;
    TQValueList<AlbumInfo> m_albumList;
};


#endif /* DIGIKAMALBUMS_H */
