/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-07-05
 * Description : a ListView to display black frames
 * 
 * Copyright (C) 2005-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2005-2006 by Unai Garro <ugarro at users dot sourceforge dot net>
 * 
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef BLACKFRAMELISTVIEW_H
#define BLACKFRAMELISTVIEW_H

// TQt includes.

#include <tqimage.h>
#include <tqstring.h>
#include <tqsize.h>
#include <tqpoint.h>
#include <tqvaluelist.h>
#include <tqlistview.h>

// KDE includes.

#include <kurl.h>
#include <klocale.h>

// Local includes.

#include "blackframeparser.h"
#include "hotpixel.h"

namespace DigikamHotPixelsImagesPlugin
{

class BlackFrameListView : public TQListView
{
    Q_OBJECT
  TQ_OBJECT

public:

    BlackFrameListView(TQWidget* parent=0);
    ~BlackFrameListView(){};

signals:

    void blackFrameSelected(TQValueList<HotPixel>, const KURL&);

private slots:

    void slotParsed(TQValueList<HotPixel> hotPixels, const KURL& blackFrameURL)
    {
       emit blackFrameSelected(hotPixels, blackFrameURL);
    };
};

// --------------------------------------------------------------------------

class BlackFrameListViewItem : public TQObject, TQListViewItem
{
Q_OBJECT
  TQ_OBJECT

public:

    BlackFrameListViewItem(BlackFrameListView* parent, const KURL &url);
    ~BlackFrameListViewItem(){};

    virtual TQString text(int column)const;
    virtual void paintCell(TQPainter* p, const TQColorGroup& cg, int column, int width, int align);
    virtual int width(const TQFontMetrics& fm, const TQListView* lv, int c)const;

signals:

    void parsed(TQValueList<HotPixel>, const KURL&);
    void signalLoadingProgress(float);
    void signalLoadingComplete();

protected:

    void activate();

private:

    TQPixmap thumb(const TQSize& size);

private slots:

    void slotParsed(TQValueList<HotPixel>);

private:

    // Data contained within each listview item
    TQImage                m_thumb;
    TQImage                m_image;

    TQSize                 m_imageSize;

    TQValueList <HotPixel> m_hotPixels;

    TQString               m_blackFrameDesc;

    KURL                  m_blackFrameURL;

    BlackFrameParser     *m_parser;

    BlackFrameListView   *m_parent;
};

}  // NameSpace DigikamHotPixelsImagesPlugin

#endif  // BLACKFRAMELISTVIEW_H
