/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-07-01
 * Description : dialog to edit and create digiKam Tags
 * 
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef TAGEDITDLG_H
#define TAGEDITDLG_H

// TQt includes.

#include <tqmap.h>
#include <tqstring.h>

// KDE includes.

#include <kdialogbase.h>

// Local includes.

#include "albummanager.h"

namespace Digikam
{
class TagEditDlgPriv;

class TagEditDlg : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:

    TagEditDlg(TQWidget *parent, TAlbum* album, bool create=false);
    ~TagEditDlg();

    TQString title() const;
    TQString icon() const;

    static bool tagEdit(TQWidget *parent, TAlbum* album, TQString& title, TQString& icon);
    static bool tagCreate(TQWidget *parent, TAlbum* album, TQString& title, TQString& icon);

    /** Create a list of new Tag album using a list of tags hierarchies separated by ",".
        A hierarchy of tags is a string path of tags name separated by "/".
        If a hierarchy start by "/" or if mainRootAlbum is null, it will be created from 
        root tag album, else it will be created from mainRootAlbum as parent album.
        'errMap' is Map of TAlbum path and error message if tag creation failed.
        Return the list of created Albums.
    */
    static AlbumList createTAlbum(TAlbum *mainRootAlbum, const TQString& tagStr, const TQString& icon,
                                  TQMap<TQString, TQString>& errMap);

    static void showtagsListCreationError(TQWidget* parent, const TQMap<TQString, TQString>& errMap);

private slots:

    void slotIconChanged();
    void slotIconResetClicked();
    void slotTitleChanged(const TQString& newtitle);

private:

    TagEditDlgPriv *d;
};

}  // namespace Digikam

#endif /* TAGEDITDLG_H */
