/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-10-04
 * Description : sync IO jobs.
 * 
 * Copyright (C) 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * Concept copied from kdelibs/kio/kio/netaccess.h/cpp
 *   This file is part of the KDE libraries
 *   Copyright (C) 1997 Torben Weis (weis@kde.org)
 *   Copyright (C) 1998 Matthias Ettrich (ettrich@kde.org)
 *   Copyright (C) 1999 David Faure (faure@kde.org)
 * 
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef SYNCJOB_H
#define SYNCJOB_H

// TQt includes.

#include <tqobject.h>
#include <tqpixmap.h>

// KDE includes.

#include <kurl.h>

class TQString;

namespace KIO
{
class Job;
}

namespace Digikam
{

class Album;
class TAlbum;

class SyncJob : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

public:

    /* this will delete the urls. */
    static bool del(const KURL::List& urls, bool useTrash);

    /* remove this when we move dependency upto kde 3.2 */
    static bool file_move(const KURL &src, const KURL &dest);

    /* Load the image or icon for the tag thumbnail */    
    static TQPixmap getTagThumbnail(TAlbum *album);
    static TQPixmap getTagThumbnail(const TQString &name, int size);

    static TQString lastErrorMsg();
    static int     lastErrorCode();
    
private:

    SyncJob();
    ~SyncJob();

    bool delPriv(const KURL::List& urls);
    bool trashPriv(const KURL::List& urls);

    bool fileMovePriv(const KURL &src, const KURL &dest);
    
    TQPixmap getTagThumbnailPriv(TAlbum *album);
    TQPixmap getTagThumbnailPriv(const TQString &name, int size);

    void enter_loop();
    
    static int      lastErrorCode_;
    static TQString* lastErrorMsg_;
    bool            success_;
    
    TQPixmap         *thumbnail_;
    Album           *album_;
    int             thumbnailSize_;

private slots:

    void slotResult( KIO::Job * job );
    void slotGotThumbnailFromIcon(Album *album, const TQPixmap& pix);
    void slotLoadThumbnailFailed(Album *album);
    void slotGotThumbnailFromIcon(const KURL& url, const TQPixmap& pix);
    void slotLoadThumbnailFailed();
};

}  // namespace Digikam

#endif /* SYNCJOB_H */
