/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2003-01-29
 * Description : Camera settings container.
 * 
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// KDE includes.

#include <kaction.h>

// Local includes.

#include "cameraui.h"
#include "cameratype.h"

namespace Digikam
{

class CameraTypePrivate
{
public:

    CameraTypePrivate()
    {
        action = 0;
    }

    TQString                title;
    TQString                model;
    TQString                port;
    TQString                path;

    TQDateTime              lastAccess;

    KAction               *action;
    bool                   valid;

    TQGuardedPtr<CameraUI>  currentCameraUI;
};

CameraType::CameraType()
{
    d = new CameraTypePrivate;
    d->valid = false;    
}

CameraType::CameraType(const TQString& title, const TQString& model,
                       const TQString& port, const TQString& path,
                       const TQDateTime& lastAccess, KAction *action)
{
    d = new CameraTypePrivate;
    d->title      = title;
    d->model      = model;
    d->port       = port;
    d->path       = path;
    d->action     = action;
    d->lastAccess = lastAccess;
    d->valid      = true;    
}

CameraType::CameraType(const CameraType& ctype)
{
    d = new CameraTypePrivate;
    d->title      = ctype.d->title;
    d->model      = ctype.d->model;
    d->port       = ctype.d->port;
    d->path       = ctype.d->path;
    d->action     = ctype.d->action;
    d->lastAccess = ctype.d->lastAccess;
    d->valid      = ctype.d->valid;
}

CameraType::~CameraType()
{
    delete d;
}

CameraType& CameraType::operator=(const CameraType& ctype)
{
    if (this != &ctype) 
    {
        d->title      = ctype.d->title;
        d->model      = ctype.d->model;
        d->port       = ctype.d->port;
        d->path       = ctype.d->path;
        d->action     = ctype.d->action;
        d->lastAccess = ctype.d->lastAccess;
        d->valid      = ctype.d->valid;
    }
    return *this;
}

void CameraType::setTitle(const TQString& title)
{
    d->title = title;
}

void CameraType::setModel(const TQString& model)
{
    d->model = model;
}

void CameraType::setPort(const TQString& port)
{
    d->port = port;
}

void CameraType::setPath(const TQString& path)
{
    d->path = path;
}

void CameraType::setLastAccess(const TQDateTime& lastAccess)
{
    d->lastAccess = lastAccess;
}

void CameraType::setAction(KAction *action)
{
    d->action = action;
}

void CameraType::setValid(bool valid)
{
    d->valid = valid;
}

void CameraType::setCurrentCameraUI(CameraUI *cameraui)
{
    d->currentCameraUI = cameraui;
}

TQString CameraType::title() const
{
    return d->title;
}

TQString CameraType::model() const
{
    return d->model;
}

TQString CameraType::port() const
{
    return d->port;
}

TQString CameraType::path() const
{
    return d->path;
}

TQDateTime CameraType::lastAccess() const
{
    return d->lastAccess;
}

KAction* CameraType::action() const
{
    return d->action;
}

bool CameraType::valid() const
{
    return d->valid;
}

CameraUI *CameraType::currentCameraUI() const
{
    return d->currentCameraUI;
}

}  // namespace Digikam
