/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CBOOKTREECHOOSER_H
#define CBOOKTREECHOOSER_H


/** The treechooser implementation for books.
  * @author The BibleTime team
  */
//BibleTime includes
#include "ckeychooser.h"
#include "ckeychooserwidget.h"

//Sword includes

//TQt includes
#include <tqwidget.h>
#include <tqsize.h>
#include <tqmap.h>
#include <tqptrlist.h>
#include <tqstringlist.h>

//KDE includes
#include <klistview.h>

class CSwordKey;
class CSwordBookModuleInfo;
class CSwordTreeKey;

namespace sword {
	class TreeKeyIdx;
}

/** The keychooser implementeation for books.
  * @author The BibleTime team
  */
class CBookTreeChooser : public CKeyChooser  {
	Q_OBJECT
  TQ_OBJECT
public:
	CBookTreeChooser(ListCSwordModuleInfo modules, CSwordKey *key=0, TQWidget *parent=0, const char *name=0);
	~CBookTreeChooser();
	/**
	* Refreshes the content.
	*/
	virtual void refreshContent();
	/**
	* Sets another module to this keychooser
	*/
	virtual void setModules(const ListCSwordModuleInfo& modules, const bool refresh = true);
	/**
	* Returns the key of this kechooser.
	*/
	virtual CSwordKey* const key();
	/**
	* Sets a new key to this keychooser
	*/
	virtual void setKey(CSwordKey*);
	void setKey(CSwordKey*, const bool emitSinal);

public slots: // Public slots
	virtual void updateKey( CSwordKey* );
	/**
	* Reimplementationm to handle tree creation on show.
	*/
	virtual void show();


protected: // Protected methods
	/**
	* Creates the first level of the tree structure.
	*/
	void setupTree();
	virtual void adjustFont();

protected slots: // Protected slots
	void itemActivated( TQListViewItem* item );

private:
class TreeItem : public KListViewItem {
public:
		TreeItem(TQListViewItem* parent, TQListViewItem* after, CSwordTreeKey* key, const TQString keyName);
		TreeItem(TQListViewItem* parent, CSwordTreeKey* key, const TQString keyName);
		TreeItem(TQListView* view,TQListViewItem* after, CSwordTreeKey* key, const TQString keyName);
		const TQString& key() const;
		void createChilds();
		virtual void setOpen(bool);

protected:
		/**
		* Initializes this item with the correct caption.
		*/
		virtual void setup();
private:
		CSwordTreeKey* m_key;
		TQString m_keyName;
	};

	TQPtrList<CSwordBookModuleInfo> m_modules;
	CSwordTreeKey* m_key;
	KListView* m_treeView;
};

#endif
