/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#include "cplainwritedisplay.h"

#include "frontend/cdragdropmgr.h"
#include "frontend/displaywindow/cdisplaywindow.h"
#include "frontend/displaywindow/cwritewindow.h"

#include "util/scoped_resource.h"

//TQt includes

//KDE includes
#include <kaction.h>
#include <klocale.h>

CPlainWriteDisplay::CPlainWriteDisplay(CWriteWindow* parentWindow, TQWidget* parent) : TQTextEdit(parentWindow ? parentWindow : parent), CWriteDisplay(parentWindow) {
	setTextFormat(TQt::PlainText);
	setAcceptDrops(true);
	viewport()->setAcceptDrops(true);

	connect(this, TQT_SIGNAL(textChanged()),
			connectionsProxy(), TQT_SLOT(emitTextChanged()));
}

CPlainWriteDisplay::~CPlainWriteDisplay() {}

/** Reimplementation. */
void CPlainWriteDisplay::selectAll() {
	TQTextEdit::selectAll(true);
}

void CPlainWriteDisplay::setText( const TQString& newText ) {
	//make sure the text has been converted to show \n instead of <br/>
	TQString text = newText;
// 	text.replace("\n<br /><!-- BT newline -->\n", "\n");
	text.replace("<br />", "\n"); //inserted by BT or the TQt textedit widget

	TQTextEdit::setText(text);
}

const bool CPlainWriteDisplay::hasSelection() {
	return hasSelectedText();
}

TQWidget* CPlainWriteDisplay::view() {
	qDebug("CPlainWriteDisplay::view()");
	return this;
}

const TQString CPlainWriteDisplay::text( const CDisplay::TextType /*format*/, const CDisplay::TextPart /*part*/) {
	return TQString();
}

void CPlainWriteDisplay::print( const CDisplay::TextPart, CSwordBackend::DisplayOptions displayOptions, CSwordBackend::FilterOptions filterOptions ) {
}

/** Sets the current status of the edit widget. */
void CPlainWriteDisplay::setModified( const bool modified ) {
	TQTextEdit::setModified(modified);
}

/** Reimplementation. */
const bool CPlainWriteDisplay::isModified() const {
	return TQTextEdit::isModified();
}


/** Returns the text of this edit widget. */
const TQString CPlainWriteDisplay::plainText() {
	TQString ret = TQTextEdit::text();

	//in plain text mode the text just contains newlines, convert them into <br/> before we return the text for display in a HTML widget
	ret.replace("\n", "<br />");

	return ret;
}

/** Reimplementation from TQTextEdit. Provides an popup menu for the given position. */
TQPopupMenu* CPlainWriteDisplay::createPopupMenu( const TQPoint& /*pos*/ ) {
	return installedPopup();
}

/** Reimplementation from TQTextEdit. Provides an popup menu for the given position. */
TQPopupMenu* CPlainWriteDisplay::createPopupMenu( ) {
	return installedPopup();
}

/** Creates the necessary action objects and puts them on the toolbar. */
void CPlainWriteDisplay::setupToolbar(KToolBar* /*bar*/, KActionCollection* /*actionCollection*/) {}

/** Reimplementation to insert the text of a dragged reference into the edit view. */
void CPlainWriteDisplay::contentsDragEnterEvent( TQDragEnterEvent* e ) {
	if (CDragDropMgr::canDecode(e)) {
		e->accept(true);
	}
	else {
		e->accept(false);
		e->ignore();
	}
}

/** Reimplementation to insert the text of a dragged reference into the edit view. */
void CPlainWriteDisplay::contentsDragMoveEvent( TQDragMoveEvent* e ) {
	if (CDragDropMgr::canDecode(e)) {
		placeCursor(e->pos());
		ensureCursorVisible();
		e->accept(true);
	}
	else {
		e->accept(false);
		e->ignore();
	}
}

/** Reimplementation to manage drops of our drag and drop objects. */
void CPlainWriteDisplay::contentsDropEvent( TQDropEvent* e ) {
	if ( CDragDropMgr::canDecode(e) ) {
		e->acceptAction();

		CDragDropMgr::ItemList items = CDragDropMgr::decode(e);
		CDragDropMgr::ItemList::iterator it;
		for (it = items.begin(); it != items.end(); ++it) {
			switch ((*it).type()) {
				case CDragDropMgr::Item::Bookmark: {
					CSwordModuleInfo* module = backend()->findModuleByName((*it).bookmarkModule());
					util::scoped_ptr<CSwordKey> key( CSwordKey::createInstance(module) );
					key->key( (*it).bookmarkKey() );

					TQString moduleText = key->strippedText();

					const TQString text = TQString::fromLatin1("%1\n(%2, %3)\n").arg(moduleText).arg((*it).bookmarkKey()).arg((*it).bookmarkModule());

					placeCursor( e->pos() );
					insert( text );
					break;
				}
				case CDragDropMgr::Item::Text: {
					placeCursor( e->pos() );
					insert( (*it).text() );
					break;
				}
				default:
				break;
			}
		}
	}
}
