/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CSWORDMODULELISTVIEW_H
#define CSWORDMODULELISTVIEW_H

//Sword includes
#include <installmgr.h>

//QT includes
#include <tqstring.h>
#include <tqmap.h>

//KDE includes
#include <klistview.h>

class CSwordModuleInfo;
class CSwordBackend;

namespace BookshelfManager {

class CSwordSetupModuleListView : public KListView {
	Q_OBJECT
  TQ_OBJECT

public:
	CSwordSetupModuleListView(TQWidget* parent, bool is_remote, sword::InstallSource* installSource = 0);
	virtual ~CSwordSetupModuleListView();

	void addModule(CSwordModuleInfo *, TQString localVersion);
	void finish();
	TQStringList selectedModules();
	void clear();

	virtual TQString tooltip(TQListViewItem* i, int column) const;
	virtual bool showTooltip(TQListViewItem* i, const TQPoint& pos, int column) const;

protected slots:
	void slotItemClicked(TQListViewItem*);

private:
	void init();

	CSwordBackend* m_backend;
	bool m_is_remote;

	TQListViewItem* m_categoryBible;
	TQListViewItem* m_categoryCommentary;
	TQListViewItem* m_categoryLexicon;
	TQListViewItem* m_categoryBook;
	TQListViewItem* m_categoryDevotionals;
	TQListViewItem* m_categoryGlossaries;

signals:
	void selectedModulesChanged();
};

} //NAMESPACE

#endif //CSWORDMODULELISTVIEW_H
