/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CSWORDSETUPDIALOG_H
#define CSWORDSETUPDIALOG_H

#include "cbtconfig.h"
#include "util/cpointers.h"
#include "btinstallmgr.h"

//QT includes
#include <tqstring.h>
#include <tqmap.h>

//KDE includes
#include <kdialogbase.h>

class TQWidget;
class TQLabel;
class TQComboBox;
class TQWidgetStack;
class TQButton;
class TQPushButton;
class TQLineEdit;
class TQListView;

class KProgressDialog;

namespace BookshelfManager {

	class CSwordSetupModuleListView;

	/**
	 * The Sword configuration dialog of BibleTime
	  * @author The BibleTime Team
	  */
class CSwordSetupDialog : public KDialogBase, public CPointers  {
		Q_OBJECT
  TQ_OBJECT

public:
		CSwordSetupDialog(TQWidget *parent=0, const char *name=0);

		enum Parts {
			Sword,
			Install,
			Remove
		};

		/** Opens the page which contaisn the given part ID. */
		const bool showPart( CSwordSetupDialog::Parts ID );

private:
		void initSwordConfig();
		void initInstall();
		void initRemove();
		void initManageIndices();

		void writeSwordConfig();

		void setupSwordPathListBox();
		void populateInstallCombos();

		const TQString currentInstallSource();

		TQFrame* m_swordConfigPage;
		TQListView* m_swordPathListBox;
		TQPushButton* m_swordEditPathButton;
		TQPushButton* m_swordAddPathButton;
		TQPushButton* m_swordRemovePathButton;
		TQStringList m_swordPathList;
		bool m_swordSetupChanged;

		TQFrame* m_removePage;
		TQFrame* m_manageIndiciesPage;

		TQFrame* m_installPage;
		TQWidgetStack* m_installWidgetStack;

		TQString source;
		TQString target;

		TQLabel* m_sourceLabel;
		TQLabel* m_targetLabel;
		TQComboBox* m_sourceCombo;
		TQComboBox* m_targetCombo;

		TQMap<TQString, TQString> m_targetMap;

		CSwordSetupModuleListView* m_removeModuleListView;
		TQPushButton* m_removeRemoveButton;

		const bool refreshRemoteModuleCache( const TQString& sourceName );
		void populateRemoveModuleListView();
		bool populateInstallModuleListView(const TQString& sourceName);

		//install module stuff
		TQPushButton* m_installBackButton;
		TQPushButton* m_installContinueButton;

		TQWidget* m_installModuleListPage;
		TQWidget* m_installSourcePage;

		CSwordSetupModuleListView* m_installModuleListView;
		KProgressDialog* m_progressDialog;
		TQString m_installingModule;
		bool m_refreshedRemoteSources;
		unsigned int m_installedModuleCount;

		BTInstallMgr* m_currentInstallMgr; //pointer to the current installmgr object so we can access it in the cancel install slot

private slots:
		void slot_sourceSelected(const TQString &sourceName);
		void slot_targetSelected(const TQString &targetName);

		void slot_doRemoveModules();

		void slotOk();

		void slot_connectToSource();
		void slot_moduleRefreshProgressCancelClicked();
		void slot_moduleRefreshCompleted(const int, const int);

		void slot_installAddSource();
		void slot_installDeleteSource();
		void slot_installModules();
		void slot_installModulesChanged();
		void slot_installProgressCancelClicked();
		void slot_showInstallSourcePage();

		void installCompleted( const int, const int );
		void slot_swordRemoveClicked();
		void slot_swordAddClicked();
		void slot_swordEditClicked();
		void slot_swordPathSelected();

signals: // Signals
		void signalSwordSetupChanged();
	};

}

#endif //CSWORDSETUPDIALOG_H
