//
// C++ Interface: cinfodisplay
//
// Description:
//
//
// Author: The BibleTime team <info@bibletime.info>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef CINFODISPLAY_H
#define CINFODISPLAY_H

//Backend
#include "backend/ctextrendering.h"

//TQt includes
#include <tqwidget.h>
#include <tqvaluelist.h>
#include <tqpair.h>

//class forward declarations
class CReadDisplay;

namespace InfoDisplay {

	/**
	@author The BibleTime team
	*/
class CInfoDisplay : public TQWidget {
		Q_OBJECT
  TQ_OBJECT
public:
		enum InfoType {
			Abbreviation,
			CrossReference,
			Footnote,
			Lemma,
			Morph,
			WordTranslation,
			WordGloss
		};

		typedef TQPair<InfoType, TQString> InfoData;
		typedef TQValueList<InfoData> ListInfoData;

		CInfoDisplay(TQWidget *parent = 0, const char *name = 0);
		virtual ~CInfoDisplay();

		void setInfo(const InfoType, const TQString& data);
		void setInfo(const ListInfoData&);
		void clearInfo();

protected:
		const TQString decodeAbbreviation( const TQString& data );
		const TQString decodeCrossReference( const TQString& data );
		const TQString decodeFootnote( const TQString& data );
		const TQString decodeStrongs( const TQString& data );
		const TQString decodeMorph( const TQString& data );
		const TQString getWordTranslation( const TQString& data );

protected slots:
		void lookup(const TQString &, const TQString &);

private:
		CReadDisplay* m_htmlPart;
	};

} //end of InfoDisplay namespace

#endif
