#if 0

// Note: this file has been copied from the TQt source.
// Those classes are normally used internally in TQt
// but we need them for immitate the roll-over effect of TQComboBox.
//
// Some class definitions have been moved from qeffects.cpp to this file.
// They are framed with the comment "MOVED FROM qeffect.cpp"

/****************************************************************************
** $Id: qt/qeffects_p.h   3.3.4   edited May 27 2003 $
**
** Definition of TQEffects functions
**
** Created : 000621
**
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the TQt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.TQPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for TQPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef TQEFFECTS_P_H
#define TQEFFECTS_P_H


//
//  W A R N I N G
//  -------------
//
// This file is not part of the TQt API.  It exists for the convenience
// of qeffects.cpp, qcombobox.cpp, qpopupmenu.cpp and qtooltip.cpp.
// This header file may change from version to version without notice,
// or even be removed.
//
// We mean it.
//
//

#ifndef TQT_H
#include "tqnamespace.h"
#endif // TQT_H

#ifndef TQT_NO_EFFECTS
class TQWidget;

struct TQEffects
{
	enum Direction {
		LeftScroll	= 0x0001,
		RightScroll	= 0x0002,
		UpScroll	= 0x0004,
		DownScroll	= 0x0008
	};

	typedef uint DirFlags;
};

extern void TQ_EXPORT qScrollEffect( TQWidget*, TQEffects::DirFlags dir = TQEffects::DownScroll, int time = -1 );
extern void TQ_EXPORT qFadeEffect( TQWidget*, int time = -1 );


/******************* MOVED FROM qeffect.cpp: */

#include "tqguardedptr.h"
#include "tqdatetime.h"
#include "tqtimer.h"
#include "tqpixmap.h"
#include "tqimage.h"

/*
  Internal class to get access to protected TQWidget-members
*/

class TQAccessWidget : public TQWidget
{
	friend class TQAlphaWidget;
	friend class TQRollEffect;
	public:
		TQAccessWidget( TQWidget* parent=0, const char* name=0, WFlags f = 0 )
	: TQWidget( parent, name, f ) {}
};

/*
  Internal class TQAlphaWidget.

  The TQAlphaWidget is shown while the animation lasts
  and displays the pixmap resulting from the alpha blending.
*/

class TQAlphaWidget: public TQWidget, private TQEffects
{
	Q_OBJECT
  TQ_OBJECT
	public:
		TQAlphaWidget( TQWidget* w, WFlags f = 0 );

		void run( int time );

	protected:
		void paintEvent( TQPaintEvent* e );
		void closeEvent( TQCloseEvent* );
		bool eventFilter( TQObject* o, TQEvent* e );
		void alphaBlend();

	protected slots:
		void render();

	private:
		TQPixmap pm;
		double alpha;
		TQImage back;
		TQImage front;
		TQImage mixed;
		TQGuardedPtr<TQAccessWidget> widget;
		int duration;
		int elapsed;
		bool showWidget;
		TQTimer anim;
		TQTime checkTime;
};

/*
  Internal class TQRollEffect

  The TQRollEffect widget is shown while the animation lasts
  and displays a scrolling pixmap.
*/

class TQRollEffect : public TQWidget, private TQEffects
{
	Q_OBJECT
  TQ_OBJECT
	public:
		TQRollEffect( TQWidget* w, WFlags f, DirFlags orient );

		void run( int time );

	protected:
		void paintEvent( TQPaintEvent* );
		bool eventFilter( TQObject*, TQEvent* );
		void closeEvent( TQCloseEvent* );

	private slots:
		void scroll();

	private:
		TQGuardedPtr<TQAccessWidget> widget;

		int currentHeight;
		int currentWidth;
		int totalHeight;
		int totalWidth;

		int duration;
		int elapsed;
		bool done;
		bool showWidget;
		int orientation;

		TQTimer anim;
		TQTime checkTime;

		TQPixmap pm;
};

/******************************/

#endif // TQT_NO_EFFECTS

#endif // TQEFFECTS_P_H

#endif // #if 0
