/***************************************************************************
 *   Copyright (C) 2006 by Petri Damsten                                   *
 *   damu@iki.fi                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PASSWORD_H
#define PASSWORD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef Q_MOC_RUN
#define HAVE_LIBGPGME
#endif

#ifdef HAVE_LIBGPGME

#include <passwordlayout.h>
#include <kdialogbase.h>

/**
	@author Petri Damsten <damu@iki.fi>
*/
class Password : public PasswordLayout
{
	Q_OBJECT
	TQ_OBJECT
	public:
		Password(TQWidget *parent, const char *name = 0);
		~Password();
};

class PasswordDlg : public KDialogBase
{
	Q_OBJECT
	TQ_OBJECT
	public:
		PasswordDlg(TQWidget *parent, const char *name = 0);
		~PasswordDlg();

		TQString key() const;
		int type() const;
		void setKey(const TQString& key);
		void setType(int type);

	protected slots:
		virtual void slotOk();

	private:
		Password* w;
};

#endif // HAVE_LIBGPGME

#endif // PASSWORD_H

