/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tqtabwidget.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqcursor.h>
#include <tqwhatsthis.h>
#include <tqvaluelist.h>
#include <tqregexp.h>
#include <tqbuttongroup.h>
#include <kstringhandler.h>

#include <ksqueezedtextlabel.h>
#include <tqpoint.h>
#include <tqpixmap.h>
#include <tqinputdialog.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kiconeffect.h>
#include <tqiconset.h>
#include <kaction.h>
#include <kapp.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kedittoolbar.h>
#include <kdebug.h>
#include <tqsignalmapper.h>
#include <tqstringlist.h>

#include <tqpainter.h>
#include <tqstyle.h>
#include <kglobalsettings.h>
#include <kstandarddirs.h>
#include <tqdir.h>
#include <tqstringlist.h>
#include <kmessagebox.h>
#include <kstatusbar.h>
#include <tqtimer.h>
#include <tqaction.h>
#include <kstdaccel.h>
#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <kpassivepopup.h>
#include <kconfig.h>
#include <kcolordialog.h>
#include <kaboutdata.h>

#include <kdeversion.h>
#include <tqdesktopwidget.h>
#include <kwin.h>

#include <kprogress.h>

#include "mainwindow.h"
#include "basket.h"
#include "basketproperties.h"
#include "note.h"
#include "noteedit.h"
#include "settings.h"
#include "global.h"
//#include "addbasketwizard.h"
#include "newbasketdialog.h"
#include "basketfactory.h"
#include "popupmenu.h"
#include "xmlwork.h"
#include "debugwindow.h"
#include "notefactory.h"
#include "notedrag.h"
#include "tools.h"
#include "tag.h"
#include "formatimporter.h"
#include "softwareimporters.h"
#include "regiongrabber.h"
#include "password.h"
#include "bnpview.h"
#include "systemtray.h"
#include "clickablelabel.h"
#include "basketstatusbar.h"
#include <iostream>
#include <ksettings/dialog.h>
#include <kcmultidialog.h>

/** Container */

MainWindow::MainWindow(TQWidget *parent, const char *name)
	: KMainWindow(parent, name != 0 ? name : "MainWindow"), m_settings(0), m_quit(false)
{
	BasketStatusBar* bar = new BasketStatusBar(statusBar());
	m_baskets = new BNPView(this, "BNPViewApp", this, actionCollection(), bar);
	setCentralWidget(m_baskets);

	setupActions();
	statusBar()->show();
	statusBar()->setSizeGripEnabled(true);

	setAutoSaveSettings(/*groupName=*/TQString::fromLatin1("MainWindow"), /*saveWindowSize=*//*FIXME:false:Why was it false??*/true);

//	m_actShowToolbar->setChecked(   toolBar()->isShown()   );
	m_actShowStatusbar->setChecked( statusBar()->isShown() );
	connect( m_baskets,      TQT_SIGNAL(setWindowCaption(const TQString &)), this, TQT_SLOT(setCaption(const TQString &)));

//	InlineEditors::instance()->richTextToolBar();
	setStandardToolBarMenuEnabled(true);

	createGUI("basketui.rc");
	applyMainWindowSettings(KGlobal::config(), autoSaveGroup());
}

MainWindow::~MainWindow()
{
	saveMainWindowSettings(KGlobal::config(), autoSaveGroup());
	delete m_settings;
}

void MainWindow::setupActions()
{
	actQuit         = KStdAction::quit( TQT_TQOBJECT(this), TQT_SLOT(quit()), actionCollection() );
	new KAction(i18n("Minimize"), "", 0,
				TQT_TQOBJECT(this), TQT_SLOT(minimizeRestore()), actionCollection(), "minimizeRestore" );
	/** Settings : ************************************************************/
//	m_actShowToolbar   = KStdAction::showToolbar(   TQT_TQOBJECT(this), TQT_SLOT(toggleToolBar()),   actionCollection());
	m_actShowStatusbar = KStdAction::showStatusbar( TQT_TQOBJECT(this), TQT_SLOT(toggleStatusBar()), actionCollection());

//	m_actShowToolbar->setCheckedState( KGuiItem(i18n("Hide &Toolbar")) );

	(void) KStdAction::keyBindings( TQT_TQOBJECT(this), TQT_SLOT(showShortcutsSettingsDialog()), actionCollection() );

	(void) KStdAction::configureToolbars(TQT_TQOBJECT(this), TQT_SLOT(configureToolbars()), actionCollection() );

	//KAction *actCfgNotifs = KStdAction::configureNotifications(this, TQT_SLOT(configureNotifications()), actionCollection() );
	//actCfgNotifs->setEnabled(false); // Not yet implemented !

	actAppConfig = KStdAction::preferences( TQT_TQOBJECT(this), TQT_SLOT(showSettingsDialog()), actionCollection() );
}

/*void MainWindow::toggleToolBar()
{
	if (toolBar()->isVisible())
		toolBar()->hide();
	else
		toolBar()->show();

	saveMainWindowSettings( KGlobal::config(), autoSaveGroup() );
}*/

void MainWindow::toggleStatusBar()
{
	if (statusBar()->isVisible())
		statusBar()->hide();
	else
		statusBar()->show();

	saveMainWindowSettings( KGlobal::config(), autoSaveGroup() );
}

void MainWindow::configureToolbars()
{
	saveMainWindowSettings( KGlobal::config(), autoSaveGroup() );

	KEditToolbar dlg(actionCollection());
	connect( &dlg, TQT_SIGNAL(newToolbarConfig()), this, TQT_SLOT(slotNewToolbarConfig()) );
	dlg.exec();
}

void MainWindow::configureNotifications()
{
	// TODO
	// KNotifyDialog *dialog = new KNotifyDialog(this, "KNotifyDialog", false);
	// dialog->show();
}

void MainWindow::slotNewToolbarConfig() // This is called when OK or Apply is clicked
{
	// ...if you use any action list, use plugActionList on each here...
	createGUI("basketui.rc"); // TODO: Reconnect tags menu aboutToShow() ??
	if (!Global::bnpView->isPart())
		Global::bnpView->connectTagsMenu(); // The Tags menu was created again!
	plugActionList( TQString::fromLatin1("go_baskets_list"), actBasketsList);
	applyMainWindowSettings( KGlobal::config(), autoSaveGroup() );
}

void MainWindow::showSettingsDialog()
{
	if(m_settings == 0)
		m_settings = new KSettings::Dialog(TQT_TQWIDGET(kapp->activeWindow()));
	if (Global::mainWindow()) {
		m_settings->dialog()->showButton(KDialogBase::Help,    false); // Not implemented!
		m_settings->dialog()->showButton(KDialogBase::Default, false); // Not implemented!
		m_settings->dialog()->exec();
	} else
		m_settings->show();
}

void MainWindow::showShortcutsSettingsDialog()
{
	KKeyDialog::configure(actionCollection(), "basketui.rc");
	//.setCaption(..)
	//actionCollection()->writeSettings();
}

void MainWindow::polish()
{
	bool shouldSave = false;

	// If position and size has never been set, set nice ones:
	//  - Set size to sizeHint()
	//  - Keep the window manager placing the window where it want and save this
	if (Settings::mainWindowSize().isEmpty()) {
//		std::cout << "Main Window Position: Initial Set in show()" << std::endl;
		int defaultWidth  = kapp->desktop()->width()  * 5 / 6;
		int defaultHeight = kapp->desktop()->height() * 5 / 6;
		resize(defaultWidth, defaultHeight); // sizeHint() is bad (too small) and we want the user to have a good default area size
		shouldSave = true;
	} else {
//		std::cout << "Main Window Position: Recall in show(x="
//		          << Settings::mainWindowPosition().x() << ", y=" << Settings::mainWindowPosition().y()
//		          << ", width=" << Settings::mainWindowSize().width() << ", height=" << Settings::mainWindowSize().height()
//		          << ")" << std::endl;
		//move(Settings::mainWindowPosition());
		//resize(Settings::mainWindowSize());
	}

	KMainWindow::polish();

	if (shouldSave) {
//		std::cout << "Main Window Position: Save size and position in show(x="
//		          << pos().x() << ", y=" << pos().y()
//		          << ", width=" << size().width() << ", height=" << size().height()
//		          << ")" << std::endl;
		Settings::setMainWindowPosition(pos());
		Settings::setMainWindowSize(size());
		Settings::saveConfig();
	}
}

void MainWindow::resizeEvent(TQResizeEvent *event)
{
//	std::cout << "Main Window Position: Save size in resizeEvent(width=" << size().width() << ", height=" << size().height() << ") ; isMaximized="
//	          << (isMaximized() ? "true" : "false") << std::endl;
	Settings::setMainWindowSize(size());
	Settings::saveConfig();

	// Added to make it work (previous lines do not work):
	//saveMainWindowSettings( KGlobal::config(), autoSaveGroup() );
	KMainWindow::resizeEvent(event);
}

void MainWindow::moveEvent(TQMoveEvent *event)
{
//	std::cout << "Main Window Position: Save position in moveEvent(x=" << pos().x() << ", y=" << pos().y() << ")" << std::endl;
	Settings::setMainWindowPosition(pos());
	Settings::saveConfig();

	// Added to make it work (previous lines do not work):
	//saveMainWindowSettings( KGlobal::config(), autoSaveGroup() );
	KMainWindow::moveEvent(event);
}

bool MainWindow::queryExit()
{
	hide();
	return true;
}

void MainWindow::quit()
{
	m_quit = true;
	close();
}

bool MainWindow::queryClose()
{
/*	if (m_shuttingDown) // Set in askForQuit(): we don't have to ask again
	return true;*/

	if (kapp->sessionSaving()) {
		Settings::setStartDocked(false); // If queryClose() is called it's because the window is shown
		Settings::saveConfig();
		return true;
	}

	if (Settings::useSystray() && !m_quit) {
		Global::systemTray->displayCloseMessage(i18n("Basket"));
		hide();
		return false;
	} else
		return askForQuit();
}

bool MainWindow::askForQuit()
{
	TQString message = i18n("<p>Do you really want to quit %1?</p>").arg(kapp->aboutData()->programName());
	if (Settings::useSystray())
		message += i18n("<p>Notice that you do not have to quit the application before ending your KDE session. "
				"If you end your session while the application is still running, the application will be reloaded the next time you log in.</p>");

	int really = KMessageBox::warningContinueCancel( this, message, i18n("Quit Confirm"),
			KStdGuiItem::quit(), "confirmQuitAsking" );

	if (really == KMessageBox::Cancel)
	{
		m_quit = false;
		return false;
	}

	return true;
}

void MainWindow::minimizeRestore()
{
	if(isVisible())
		hide();
	else
		show();
}

void MainWindow::changeActive()
{
#if KDE_IS_VERSION( 3, 2, 90 ) // KDE 3.3.x
	kapp->updateUserTimestamp(); // If "activate on mouse hovering systray", or "on drag throught systray"
	Global::systemTray->toggleActive();
#else
	setActive( ! isActiveWindow() );
#endif
}

#include "mainwindow.moc"
