/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef FOCUSEDWIDGETS_H
#define FOCUSEDWIDGETS_H

#include <ktextedit.h>
#include <kcolorcombo.h>
#include <kfontcombo.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kapplication.h>
#include <tqclipboard.h>

class FocusedTextEdit : public KTextEdit
{
  Q_OBJECT
  TQ_OBJECT
  public:
	FocusedTextEdit(bool disableUpdatesOnKeyPress, TQWidget *parent = 0, const char *name = 0);
	~FocusedTextEdit();
	void paste();
	TQTextCursor* textCursor() const;
  protected:
	void adaptClipboardText(TQClipboard::Mode mode);
	void keyPressEvent(TQKeyEvent *event);
	void wheelEvent(TQWheelEvent *event);
	void enterEvent(TQEvent *event);
	TQPopupMenu* createPopupMenu(const TQPoint &pos);
  signals:
	void escapePressed();
	void mouseEntered();
  private:
	bool m_disableUpdatesOnKeyPress;
};

// TODO: Rename to EscapableKColorCombo
class FocusedColorCombo : public KColorCombo
{
  Q_OBJECT
  TQ_OBJECT
  public:
	FocusedColorCombo(TQWidget *parent = 0, const char *name = 0);
	~FocusedColorCombo();
  protected:
	void keyPressEvent(TQKeyEvent *event);
  signals:
	void escapePressed();
	void returnPressed2();
};

// TODO: Rename to EscapableKFontCombo
class FocusedFontCombo : public KFontCombo
{
  Q_OBJECT
  TQ_OBJECT
  public:
	FocusedFontCombo(TQWidget *parent = 0, const char *name = 0);
	~FocusedFontCombo();
  protected:
	void keyPressEvent(TQKeyEvent *event);
  signals:
	void escapePressed();
	void returnPressed2();
};

// TODO: Rename to EscapableKComboBox
class FocusedComboBox : public KComboBox
{
  Q_OBJECT
  TQ_OBJECT
  public:
	FocusedComboBox(TQWidget *parent = 0, const char *name = 0);
	~FocusedComboBox();
  protected:
	void keyPressEvent(TQKeyEvent *event);
  signals:
	void escapePressed();
	void returnPressed2();
};

// TODO: Rename to EscapableKLineEdit
class FocusedLineEdit : public KLineEdit
{
  Q_OBJECT
  TQ_OBJECT
  public:
	FocusedLineEdit(TQWidget *parent = 0, const char *name = 0);
	~FocusedLineEdit();
  protected:
	void keyPressEvent(TQKeyEvent *event);
	void enterEvent(TQEvent *event);
  signals:
	void escapePressed();
	void mouseEntered();
};

#endif // FOCUSEDWIDGETS_H
