/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef EXPORTERDIALOG_H
#define EXPORTERDIALOG_H

#include <kdialogbase.h>

class KURLRequester;
class TQCheckBox;
class TQString;

class Basket;

/**
  * @author Sbastien Laot
  */
class ExporterDialog : public KDialogBase
{
  Q_OBJECT
  TQ_OBJECT
  public:
	ExporterDialog(Basket *basket, TQWidget *parent = 0, const char *name = 0);
	~ExporterDialog();
	TQString filePath();
	bool    embedLinkedFiles();
	bool    embedLinkedFolders();
	bool    erasePreviousFiles();
	bool    formatForImpression();
	void show();
  protected slots:
	void slotOk();
	void load();
	void save();
  private:
	Basket        *m_basket;
	KURLRequester *m_url;
	TQCheckBox     *m_embedLinkedFiles;
	TQCheckBox     *m_embedLinkedFolders;
	TQCheckBox     *m_erasePreviousFiles;
	TQCheckBox     *m_formatForImpression;
};

#endif // EXPORTERDIALOG_H
