/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef COLORPICKER_H
#define COLORPICKER_H

#include <tqdesktopwidget.h>

/** Class to pick a color on the screen
  * @author S�astien Laot
  */
class DesktopColorPicker : public TQDesktopWidget
{
  Q_OBJECT
  TQ_OBJECT
  public:
	/** Construtor, initializer and destructor */
	DesktopColorPicker();
	~DesktopColorPicker();
  public slots:
	/** Begin color picking.
	  * This function returns immediatly, and pickedColor() is emitted if user has
	  * choosen a color, and not canceled the process (by pressing Escape).
	  */
	void pickColor();
  signals:
	/** When user picked a color, this signal is emitted.
	  */
	void pickedColor(const TQColor &color);
	/** When user cancel a picking (by pressing Escape), this signal is emitted.
	  */
	void canceledPick();
  protected slots:
	void slotDelayedPick();
  protected:
	void mouseReleaseEvent(TQMouseEvent *event);
	void keyPressEvent(TQKeyEvent *event);
	bool m_gettingColorFromScreen;
};

#endif // COLORPICKER_H
