/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef BASKETLISTVIEW_H
#define BASKETLISTVIEW_H

#include <klistview.h>
#include <tqtimer.h>

class Basket;

class BasketListViewItem : public TQListViewItem
{
	public:
	/// CONSTRUCTOR AND DESTRUCTOR:
		BasketListViewItem(TQListView     *parent, Basket *basket);
		BasketListViewItem(TQListViewItem *parent, Basket *basket);
		BasketListViewItem(TQListView     *parent, TQListViewItem *after, Basket *basket);
		BasketListViewItem(TQListViewItem *parent, TQListViewItem *after, Basket *basket);
		~BasketListViewItem();
		///
		bool acceptDrop(const TQMimeSource *mime) const;
		void dropped(TQDropEvent *event);
		Basket *basket() { return m_basket; }
		void setup();
		int width(const TQFontMetrics &fontMetrics, const TQListView *listView, int column) const;
		BasketListViewItem* lastChild();
		BasketListViewItem* prevSibling();
		BasketListViewItem* shownItemAbove();
		BasketListViewItem* shownItemBelow();
		TQStringList childNamesTree(int deep = 0);
		void moveChildsBaskets();
		void ensureVisible();
		bool isShown();
		bool isCurrentBasket();
		void paintCell(TQPainter *painter, const TQColorGroup &colorGroup, int column, int width, int align);
		TQString escapedName(const TQString &string);
		///
		TQPixmap circledTextPixmap(const TQString &text, int height, const TQFont &font, const TQColor &color);
		TQPixmap foundCountPixmap(bool isLoading, int countFound, bool childsAreLoading, int countChildsFound, const TQFont &font, int height);
		bool haveChildsLoading();
		bool haveHiddenChildsLoading();
		bool haveChildsLocked();
		bool haveHiddenChildsLocked();
		int countChildsFound();
		int countHiddenChildsFound();

		void setUnderDrag(bool);
		bool isAbbreviated();
		///
//	TQDragObject* dragObject();
//	bool acceptDrop ( const TQMimeSource * mime ) const;
	private:
		Basket *m_basket;
		int     m_width;
		bool m_isUnderDrag;
		bool m_isAbbreviated;
};

class BasketTreeListView : public KListView
{
	Q_OBJECT
  TQ_OBJECT
	public:
		BasketTreeListView(TQWidget *parent = 0, const char *name = 0);
		void contentsDragEnterEvent(TQDragEnterEvent *event);
		void removeExpands();
		void contentsDragLeaveEvent(TQDragLeaveEvent *event);
		void contentsDragMoveEvent(TQDragMoveEvent *event);
		void contentsDropEvent(TQDropEvent *event);
		void resizeEvent(TQResizeEvent *event);
		void paintEmptyArea(TQPainter *painter, const TQRect &rect);
	protected:
		void focusInEvent(TQFocusEvent*);
		void viewportResizeEvent(TQResizeEvent *event);
	private:
		TQTimer         m_autoOpenTimer;
		TQListViewItem *m_autoOpenItem;
	private slots:
		void autoOpen();
	private:
		void setItemUnderDrag(BasketListViewItem* item);
		BasketListViewItem* m_itemUnderDrag;

};

#endif // BASKETLISTVIEW_H
