// (c) Pierpaolo Di Panfilo 2004
// (c) Alexandre Pereira de Oliveira 2005
// (c) 2006 Peter C. Ndikuwera <pndiku@gmail.com>
// See COPYING file for licensing information

#ifndef SMARTPLAYLISTEDITOR_H
#define SMARTPLAYLISTEDITOR_H

#include <kdialogbase.h> //baseclass
#include <tqdom.h>
#include <tqhbox.h>       //baseclass
#include <tqptrlist.h>    //definition required
#include <klineedit.h>   //inline function

class KComboBox;
class KIntSpinBox;
class KLineEdit;
class TQCheckBox;
class TQDateEdit;
class TQLabel;
class TQToolButton;
class TQVGroupBox;

class CriteriaEditor;

class SmartPlaylistEditor : public KDialogBase
{
Q_OBJECT
  TQ_OBJECT
    friend class CriteriaEditor;

    public:
        SmartPlaylistEditor( TQString playlist_name, TQWidget *parent, const char *name=0 );
        SmartPlaylistEditor( TQWidget *parent, TQDomElement xml, const char *name=0 );

        TQDomElement result();

        TQString name() const { return m_nameLineEdit->text().replace( "\n", " " ); }

        enum CriteriaType { criteriaAll = 0, criteriaAny = 1 };

    public slots:
        void addCriteriaAny();
        void addCriteriaAny( TQDomElement &xml);
        void removeCriteriaAny( CriteriaEditor *criteria);

        void addCriteriaAll();
        void addCriteriaAll( TQDomElement &xml);
        void removeCriteriaAll( CriteriaEditor *criteria);

    private slots:
        void updateOrderTypes( int index );

    private:
        void init(TQString defaultName);
        void updateMatchWidgets();

        KLineEdit *m_nameLineEdit;

        TQCheckBox *m_matchAnyCheck;
        TQCheckBox *m_matchAllCheck;

        // matching boxes
        TQVGroupBox *m_criteriaAnyGroupBox;
        TQVGroupBox *m_criteriaAllGroupBox;

        //limit widgets
        TQCheckBox *m_limitCheck;
        KIntSpinBox *m_limitSpin;
        //order by widgets
        TQCheckBox *m_orderCheck;
        KComboBox *m_orderCombo;
        KComboBox *m_orderTypeCombo;
        //expand by
        TQCheckBox *m_expandCheck;
        KComboBox *m_expandCombo;

        TQPtrList<CriteriaEditor> m_criteriaEditorAnyList;
        TQPtrList<CriteriaEditor> m_criteriaEditorAllList;
};



class CriteriaEditor : public TQHBox
{
Q_OBJECT
  TQ_OBJECT
    public:
        CriteriaEditor( SmartPlaylistEditor *editor, TQWidget *parent, int criteriaType, TQDomElement criteria = TQDomElement() );
        ~CriteriaEditor();
        TQString getSearchCriteria();
        void setSearchCriteria( const TQString &str );
        TQDomElement getDomSearchCriteria( TQDomDocument &doc );
        void enableRemove( bool );

    private slots:
        void slotRemoveCriteriaAny();
        void slotRemoveCriteriaAll();
        void slotAddCriteriaAny();
        void slotAddCriteriaAll();
        void slotFieldSelected( int );
        void loadEditWidgets();

    private:
        enum ValueType { String, AutoCompletionString, Number, Year, Date, Rating, Length };

        void loadCriteriaList( int valueType, TQString condition = TQString() );
        int getValueType( int fieldIndex );
        inline int indexToRating( int );
        inline int ratingToIndex( int );

        SmartPlaylistEditor *m_playlistEditor;
        int m_currentValueType;
        TQString m_lastCriteria;

        KComboBox *m_fieldCombo;
        KComboBox *m_criteriaCombo;
        TQToolButton *m_addButton;
        TQToolButton *m_removeButton;

        //editing widgets
        TQHBox *m_editBox;
        KLineEdit *m_lineEdit;
        KComboBox *m_comboBox;
        KComboBox *m_comboBox2;
        KIntSpinBox *m_intSpinBox1;
        KIntSpinBox *m_intSpinBox2;
        TQDateEdit *m_dateEdit1;
        TQDateEdit *m_dateEdit2;
        KComboBox *m_dateCombo;
        TQLabel *m_rangeLabel;
	KComboBox *m_lengthCombo;
};

inline int
CriteriaEditor::indexToRating( int index )
{
    if ( index <= 10 && index >= 0 ) return index;
    return -1;
}

inline int
CriteriaEditor::ratingToIndex( int rating )
{
    if ( rating <= 10 && rating >= 0 ) return rating;
    return -1;
}

#endif
