//
// C++ Interface: mediumpluginmanager
//
// Description:
//
//
// Author: Jeff Mitchell <kde-dev@emailgoeshere.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MEDIUMPLUGINMANAGER_H
#define MEDIUMPLUGINMANAGER_H

#include "amarok.h"
#include "hintlineedit.h"
#include "plugin/pluginconfig.h"

#include <tqlayout.h>
#include <tqmap.h>
#include <tqhbox.h>

#include <kconfig.h>
#include <kdialogbase.h>
#include <klocale.h>

class TQButton;
class TQGroupBox;
class TQLabel;
class TQSignalMapper;
class TQVBox;
class KComboBox;
class KLineEdit;
class Medium;
class MediumPluginManager;

typedef TQMap<TQString, Medium*> DeletedMap;

/**
    @author Jeff Mitchell <kde-dev@emailgoeshere.com>
    @author Martin Aumueller <aumuell@reserv.at>
*/

class MediaDeviceConfig : public TQHBox
{
    Q_OBJECT
  TQ_OBJECT

    public:
        MediaDeviceConfig( Medium *medium, MediumPluginManager *mgr, const bool nographics=false, TQWidget *parent=0, const char *name=0 );
        ~MediaDeviceConfig();
        TQString oldPlugin();
        void setOldPlugin( const TQString &oldPlugin );
        TQString plugin();
        KComboBox *pluginCombo();
        TQButton *configButton();
        TQButton *removeButton();
        Medium *medium();
        bool isNew();

    public slots:
        void configureDevice();
        void deleteDevice();

    signals:
        void deleteMedium( Medium *medium );
        void changed();

    protected:
        MediumPluginManager *m_manager;
        Medium *m_medium;
        TQString m_oldPlugin;
        KComboBox * m_pluginCombo;
        TQButton *m_configButton;
        TQButton *m_removeButton;
        bool m_new;
};

typedef TQValueList<MediaDeviceConfig *> DeviceList;

class MediumPluginManager : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

    friend class DeviceManager;

    public:
        //nographics only for the initial run of detectDevices...pass in
        //directly to detectDevices after
        MediumPluginManager( TQWidget *widget, const bool nographics=false );
        ~MediumPluginManager();
        void finished();
        bool hasChanged();

    signals:
        void selectedPlugin( const Medium*, const TQString );
        void changed();

    public slots:
        void redetectDevices();
        void newDevice();
        void deleteMedium( Medium *medium );
        void slotChanged();

    private:
        bool detectDevices( bool redetect=false, bool nographics=false );
        DeletedMap m_deletedMap;
        DeviceList m_deviceList;
        TQWidget *m_widget;
        bool m_hasChanged;

};

class MediumPluginManagerDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

    public:
        MediumPluginManagerDialog();
        ~MediumPluginManagerDialog();

    private slots:
        void slotOk();

    private:

        TQVBox *m_devicesBox;
        TQGroupBox *m_location;
        MediumPluginManager *m_manager;
};

class ManualDeviceAdder : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

    public:
        ManualDeviceAdder( MediumPluginManager* mdm );
        ~ManualDeviceAdder();
        bool successful() const { return m_successful; }
        Medium* getMedium( bool recreate = false );
        TQString getPlugin() const { return m_selectedPlugin; }

    private slots:
        void slotCancel();
        void slotOk();
        void comboChanged( const TQString & );

    private:
        MediumPluginManager* m_mpm;
        bool m_successful;
        TQString m_comboOldText;
        TQString m_selectedPlugin;
        Medium *m_newMed;

        KComboBox* m_mdaCombo;
        HintLineEdit* m_mdaName;
        HintLineEdit* m_mdaMountPoint;
};

#endif

