#include <stdlib.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kuniqueapplication.h>

#include "app.h"

static KCmdLineOptions options[] =
{
    KCmdLineLastOption
};

int main(int argc, char *argv[])
{

    KLocale::setMainCatalogue("adept");

    putenv( "TQT_IM_MODULE=xim" );
    TQString description = i18n("Adept Manager");

    KAboutData aboutData( "adept_manager",
                          I18N_NOOP("Adept Manager"),
                          "2.1 Cruiser",
                          description.latin1(),
                          KAboutData::License_BSD,
                          I18N_NOOP("(c) 2005, 2006 Peter Rockai"),
                          0,
                          "http://web.mornfall.net/adept.html");

    aboutData.addAuthor ( "Peter Rockai",
                          I18N_NOOP("developer"),
                          "me at mornfall dot net",
                          "http://web.mornfall.net");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );

    KApplication app;

    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
    // if (args && args->isSet("xy")) ...

    /* KConfig* config = KGlobal::config();
    config->setGroup("General Settings");
    TQString version = config->readEntry("Version"); */

    KGlobal::locale()->insertCatalogue(TQString::fromUtf8("libept"));
    KGlobal::locale()->insertCatalogue(TQString::fromUtf8("libapt-front"));

    TestApp *ta = new TestApp();

    app.setMainWidget(ta);
    ta->show();

    return app.exec();
}
