/** -*- C++ -*-
	@file adept/taglist.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <tqvbox.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <kiconloader.h>
#include <vector>

#include <apt-front/cache/entity/tag.h>

#ifndef EPT_TAGLIST_H
#define EPT_TAGLIST_H

class TQLabel;

namespace adept {

using namespace aptFront;

class TagList;

class TagLabel : public TQHBox
{
    Q_OBJECT
  TQ_OBJECT
public:
    typedef cache::entity::Tag Tag;
    TagLabel( Tag t, TagList *l, TQWidget *p = 0, const char *n = 0 );
    Tag tag() { return m_tag; }
protected:
    void mouseReleaseEvent( TQMouseEvent *e );
    Tag m_tag;
    TQLabel *m_remove;
    TQLabel *m_description;
    TagList *m_list;
};

class TagList : public TQVBox
{
    Q_OBJECT
  TQ_OBJECT
public:
    typedef cache::entity::Tag Tag;
    TagList( TQWidget *p = 0, const char *n = 0 );
    void setTags( Tag::Set t );
    void addTag( Tag t );
    Tag::Set tags() { return m_tags; }
    void setName( TQString n );
public slots:
    void scheduleUpdateList();
    void updateList();
signals:
    void tagsChanged( TagList::Tag::Set );
protected:
    void mouseMoveEvent( TQMouseEvent *e );
    void dropEvent( TQDropEvent * );
    void dragEnterEvent( TQDragEnterEvent * );
    void appendLabel( TagLabel * );
    void clearList();

    bool m_updateScheduled;
    Tag::Set m_tags;
    TQLabel *m_name;
    TQVBox *m_tagBox;
    TQSpacerItem *m_tagSpacer;
    typedef std::vector< TagLabel * > List;
    List m_list;
};

}

#endif
