/* -*- C++ -*- adept/tagfilter.h
   written by Peter Rockai <me@mornfall.net> */

#include <klocale.h>
#include <tqlayout.h>
#include <tqtimer.h>
#include <tqpoint.h>

#include <apt-front/cache/entity/entity.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/entity/tag.h>
#include <apt-front/predicate/factory.h>

#include <adept/quickfilterui.h>
#include <adept/filterlist.h>
#include <adept/lister.h>
#include <adept/taglist.h>
#include <adept/tagfilterui.h>
#include <adept/utils.h>

#ifndef EPT_TAGFILTER_H
#define EPT_TAGFILTER_H

namespace adept {

using namespace Tagcoll;

template< typename T >
struct TagFilter : predicate::Implementation< T, TagFilter< T > >,
    InterfacingPredicate, cache::Observer
{
    typedef cache::entity::Tag Tag;

    TagFilter() {
        setupPredicate();
        observeComponent< cache::component::Tags >();
    }

    void setupPredicate() {
        Cache &cache = cache::Global::get(); // FIXME?
        m_op = predicate::Factory< T >::tagSet( m_wanted );
        for (Tag::Set::iterator i = m_unwanted.begin(); i != m_unwanted.end(); ++i ) {
            m_op = m_op and not predicate::Factory< T >::tag( *i );
        }
    }

    std::string summary() const {
        return u8( i18n( "Tag Filter" ) );
    }

    void parseArguments( const predicate::ArgumentList & ) {}

    bool operator==( const TagFilter &o ) const {
        return o.m_wanted == m_wanted && o.m_unwanted == m_unwanted;
    }

    bool operator()( const T &p ) {
        return m_op( p );
    }

    void setWanted( Tag::Set t ) {
        m_wanted = t;
        setupPredicate();
    }

    void setUnwanted( Tag::Set t ) {
        m_unwanted = t;
        setupPredicate();
    }

    Tag::Set wanted() const { return m_wanted; }
    Tag::Set unwanted() const { return m_unwanted; }

    void notifyPreRebuild( cache::component::Base * ) {
        kdDebug() << "TagFilter pre-rebuild" << endl;
        m_unwanted.clear(); m_wanted.clear();
    }

    void notifyPostRebuild( cache::component::Base * ) {
        Cache &c = cache::Global::get( m_cache );
        setupPredicate();
    }

    virtual void reset() {
        m_wanted.clear();
        m_unwanted.clear();
        setupPredicate();
    }

protected:
    predicate::Predicate< T > m_op;
    Tag::Set m_wanted;
    Tag::Set m_unwanted;
};

class TagFilterWidget : public TagFilterUi
{
    Q_OBJECT
  TQ_OBJECT
public:
    TagFilterWidget( TQWidget *p, const char *n );
    virtual Predicate predicate();
public slots:
    void predicateChanged();
    void wantedChanged();
    void unwantedChanged();
protected:
    TagList *m_addingTo;
    std::vector< entity::Tag > m_tagMenuMap;
};

}

#endif
