#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <tqobjectlist.h>
#include <klocale.h>
#include <kdebug.h>
#include <klineedit.h>
#include <tqcheckbox.h>

#include "quickfilter.h"

using namespace aptFront;
using namespace adept;

QuickFilterWidget::QuickFilterWidget( TQWidget *parent, const char *name )
    : QuickFilterUi( parent, name )
{
    setFocusProxy( m_match );
    connect( m_match, TQT_SIGNAL( textChanged( const TQString & ) ),
             this, TQT_SLOT( textChanged( const TQString & ) ) );
    /* connect( m_reset, TQT_SIGNAL( clicked() ),
       this, TQT_SLOT( reset() ) ); */
    connect( m_match, TQT_SIGNAL( returnPressed() ),
             this, TQT_SLOT( widgetsChanged() ) );
    connect( &timer, TQT_SIGNAL( timeout() ),
             this, TQT_SLOT( widgetsChanged() ) );

    TQObjectList *chld = queryList( TQCHECKBOX_OBJECT_NAME_STRING );
    TQObjectListIt it( *chld );
    while( it.current() != 0 ) {
        connect( it.current(), TQT_SIGNAL( toggled( bool )  ),
                 this, TQT_SLOT( widgetsChanged() ) );
        ++it;
    }
}

void QuickFilterWidget::mouseReleaseEvent( TQMouseEvent *e ) {
    m_match->setFocus();
    QuickFilterUi::mouseReleaseEvent( e );
}

void QuickFilterWidget::textChanged( const TQString & )
{
    kdDebug() << "QuickFilterWidget::textChanged" << endl;
    timer.start( 1000, true );
}

QuickFilterWidget::Predicate QuickFilterWidget::predicate()
{
    typedef QuickFilter< entity::Package > F;
    F f; int w = 0;
    if ( m_name->isChecked() ) w |= F::Name;
    if ( m_description->isChecked() ) w |= F::Description;
    if ( m_maintainer->isChecked() ) w |= F::Maintainer;

    f.setMatch( u8( m_match->text() ) );
    f.setWhat( w );

    return predicate::adapt< entity::Entity >( f );
}

static void blockedSet( TQCheckBox *b, bool v ) {
    b->blockSignals( true );
    b->setChecked( v );
    b->blockSignals( false );
}

void QuickFilterWidget::predicateChanged() {
    typedef QuickFilter< entity::Package > F;
    F f = downcast< F >( m_pred );
    m_match->blockSignals( true );
    m_match->setText( f.match() );
    m_match->blockSignals( false );
    int w = f.what();

    blockedSet( m_name, w & F::Name );
    blockedSet( m_description, w & F::Description );
    blockedSet( m_maintainer, w & F::Maintainer );
}

