#include <cassert>

#include <tqwidgetstack.h>
#include <tqpushbutton.h>
#include <tqlabel.h>
#include <kprogress.h>
#include <tqlayout.h>
#include <tqtimer.h>

#include <klocale.h>
#include <kdebug.h>
#include <ktrader.h>
#include <klibloader.h>

#include <apt-front/init.h>
#include <adept/commitprogress.h>
#include <adept/utils.h>

using namespace adept;
using namespace aptFront;

PkgSystem *CommitProgress::s_system = 0;

void CommitProgress::initSystem() {
    CommitProgress::s_system = new PkgSystem();
}

CommitProgress::CommitProgress( TQWidget *p, const char *n )
    : CommitProgressUi( p, n )
{
    assert( s_system );
    m_konsoleFrame->installEventFilter( this );
    loadKonsole();
    connect( s_system, TQT_SIGNAL( statusChanged( int, TQString ) ),
             this, TQT_SLOT( updateProgress( int, TQString ) ) );
    connect( m_details, TQT_SIGNAL( clicked() ),
             this, TQT_SLOT( toggleDetails() ) );
    m_progress->setTotalSteps( 100 );
}

bool CommitProgress::eventFilter( TQObject *o, TQEvent *e ) {
    // o == m_konsoleFrame
    if ( e->type() == TQEvent::Resize ) {
        TQResizeEvent *re = dynamic_cast< TQResizeEvent * >( e );
        if ( !re ) return false;
        m_konsole->widget()->setGeometry( 0, 0, re->size().width(), re->size().height() );
        m_occlude->setGeometry( 0, 0, re->size().width(), re->size().height() );
    }
    return false;
};

void CommitProgress::toggleDetails()
{
    if ( !m_occlude->isVisible() ) {
    // if ( m_stack->visibleWidget() == m_konsole->widget() ) { // hide
        // m_stack->raiseWidget( m_emptyPage );
        m_occlude->show();
        m_bottomSpace->changeSize( 10, 10, TQSizePolicy::Fixed, TQSizePolicy::Expanding );
        m_details->setText( i18n( "Show Details" ) );
    } else { // show
        m_occlude->hide();
        // m_stack->raiseWidget( m_konsole->widget() );
        m_bottomSpace->changeSize( 10, 10, TQSizePolicy::Fixed, TQSizePolicy::Fixed );
        m_details->setText( i18n( "Hide Details" ) );
    }
}

void CommitProgress::updateProgress( int p, TQString msg )
{
    m_operation->setText( msg );
    m_progress->setProgress( p );
}

void CommitProgress::loadKonsole()
{
    if ( s_system->terminal() )
        kdDebug() << "WARNING: Hijacking PkgSystem terminal" << endl;

    KLibFactory* factory = KLibLoader::self()->factory( "libsanekonsolepart" );
    if (!factory)
        factory = KLibLoader::self()->factory( "libkonsolepart" );

    assert( factory );

    delete m_occlude;
    m_konsole = static_cast<KParts::Part*>(
        factory->create( m_konsoleFrame, "konsolepart", TQOBJECT_OBJECT_NAME_STRING,
                         u8( "KParts::ReadOnlyPart" ) ) );
    // m_konsole->widget()->setGeometry( TQRect( 0, 0, 40, 40 ) );

    m_occlude = new TQFrame( m_konsoleFrame, "m_occlude" );
    // m_occlude->setGeometry( TQRect( 0, 0, 10, 10 ) );
    m_occlude->setFrameShape( TQFrame::NoFrame );

    assert( terminal() );

    terminal()->setAutoDestroy( false );
    terminal()->setAutoStartShell( false );
    // m_stack->addWidget( m_konsole->widget() );

    TQStrList l; l.append( "echo" ); l.append( "-n" );
    terminal()->startProgram( u8( "/bin/echo" ), l );

    s_system->setTerminal( m_konsole );

    // m_stack->raiseWidget( m_konsole->widget() );
    // m_konsole->widget()->show();
    // m_stack->raiseWidget( m_emptyPage );
    m_operation->setText( i18n( "Idle" ) );
    TQTimer::singleShot( 0, this, TQT_SLOT( toggleDetails() ) );
    if ( DEFAULT_KONSOLE_HIDDEN )
        TQTimer::singleShot( 0, this, TQT_SLOT( toggleDetails() ) );
    TQTimer::singleShot( 0, this, TQT_SLOT( hide() ) );
}

