/** -*- C++ -*-
    @file adept/groupeddestkopselector.cpp
    @author Peter Rockai <me@mornfall.net>
*/

#include <tqobjectlist.h>
#include <tqvbox.h>
#include <tqlabel.h>
#include <tqtimer.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kseparator.h>
#include <kapplication.h>

#include <apt-front/cache/component/desktop.h>
#include <adept/groupeddesktopselector.h>
#include <adept/desktoplist.h>
#include <adept/utils.h>

using namespace aptFront;
using namespace cache;

namespace adept {

GroupedDesktopSelector::GroupedDesktopSelector( TQWidget *p, const char *n )
    : KJanusWidget( p, n, IconList ), m_policy( 0 )
{
    observeComponent< cache::component::Packages >();
    m_pages.push_back( addPage( TQString( "Initializing..." ) ) );
    TQObjectList *chld = queryList( TQWIDGET_OBJECT_NAME_STRING );
    TQObjectListIt it( *chld ); TQWidget *o;
    while ((o = dynamic_cast< TQWidget * >( it.current() )) != 0) {
        if ( dynamic_cast< TQLabel * >( o ) != 0 )
            o->hide();
        if ( dynamic_cast< KSeparator * >( o ) != 0 )
            o->hide();
        ++it;
    } // *hack*
    
    // AAAA hack
    TQLayoutIterator li = layout()->iterator();
    TQHBoxLayout *hbox = 0;
    while ( li.current() != 0 ) {
        hbox = dynamic_cast< TQHBoxLayout * >( li.current() );
        if ( hbox ) break;
        ++li;
    }
    kdDebug() << "hacking hbox = " << hbox << endl;
    if ( hbox ) {
        li = hbox->iterator();
        while ( li.current() != 0 ) {
            TQSpacerItem *spacer = dynamic_cast< TQSpacerItem * >( li.current() );
            if ( spacer ) {
                hbox->removeItem( spacer );
                delete spacer;
            }
            ++li;
        }
    }
}

void GroupedDesktopSelector::notifyPreRebuild( component::Base * ) {
    clear();
}

void GroupedDesktopSelector::notifyPostRebuild( component::Base * ) {
    // TQTimer::singleShot( 0, this, TQT_SLOT( fill() ) );
}

void GroupedDesktopSelector::clear()
{
    if ( !m_pages.empty() )
        showPage( m_pages.front() );
    while ( !m_pages.empty() ) {
        removePage( m_pages.back() );
        delete m_pages.back();
        m_pages.pop_back();
    }
}

void GroupedDesktopSelector::fill()
{
    component::Desktop &d = cache::Global::get().component< component::Desktop >();
    fill( d.entries() );
}

void GroupedDesktopSelector::fill( component::Desktop::EntityRange r )
{
    component::Desktop &d = cache::Global::get().component< component::Desktop >();
    utils::Range< std::string > gr;
    TQString last = pageTitle( activePageIndex() );

    clear();

    bool shown = false;

    for ( gr = d.availableGroups( r ); gr != gr.end(); gr.advance() ) {

        component::Desktop::EntityRange cr = d.group( *gr );
        TQString name = u8( *gr );
        std::cerr << "group for " << cr->name() << ": " << r->group() << std::endl;
        name = ( name != u8( "" ) ? name : u8( "Legacy" ) );

        TQPixmap icon( KGlobal::iconLoader()->iconPath(
                          policy() ? policy()->iconForGroup( name ) : u8( "" ), -32 ) );

        TQVBox *b = addVBoxPage( name, name, icon );
        m_pages.push_back( b );
        std::cerr << "creating list for " << *gr << std::endl;

        DesktopList *l = new DesktopList( b );
        l->setTitle( name );
        connect( l, TQT_SIGNAL( request( cache::entity::Package,
                                     cache::component::State::Action ) ),
                 this, TQT_SIGNAL( request( cache::entity::Package,
                                        cache::component::State::Action ) ) );
        connect( l, TQT_SIGNAL( showDescription( cache::entity::Desktop ) ),
                 this, TQT_SIGNAL( showDescription( cache::entity::Desktop ) ) );

        l->insertRange( intersectionRange( r, cr ) );
        // l->insertRange( cr );

        std::cerr << "created list for " << *gr << std::endl;
        if ( name == last ) {
            showPage( b );
            shown = true;
        }
        kapp->processEvents();
    }

    if ( m_pages.empty() )
        m_pages.push_back( addPage( TQString( "No Results" ) ) );
    if ( !shown )
        showPage( pageIndex( m_pages.front() ) );
}

}
