#include <cstddef>
#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <klocale.h>
#include <klineedit.h>
#include "filterwidget.h"

using namespace aptFront;
using namespace adept;

void FilterWidget::connectLister( Lister *l ) {
    connect( this, TQT_SIGNAL( drop( ListerPredicate ) ),
             l, TQT_SLOT( interactiveDrop( ListerPredicate ) ) );
    connect( this, TQT_SIGNAL( changed( ListerPredicate ) ),
             l, TQT_SLOT( interactiveAnd( ListerPredicate ) ) );
    connect( this, TQT_SIGNAL( apply( ListerPredicate ) ),
             l, TQT_SLOT( baseAnd( ListerPredicate ) ) );

}

void FilterWidget::changedInternal() {
    setEnabled( false );
    emit drop( m_old );
    emit changed( m_old = predicate() );
    setEnabled( true );
    setFocus();
}

void FilterWidget::applyInternal() {
    // check for emptiness?
    setEnabled( false );
    emit drop( m_old );
    emit apply( m_old = predicate() );
    reset();
    setEnabled( true );
    setFocus();
}
