#include <cstddef>
#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <klocale.h>
#include <kdebug.h>
#include <tqcombobox.h>
#include <tqpushbutton.h>
#include "easytagfilter.h"

using namespace aptFront;
using namespace adept;

static void fillCombo( TQComboBox *c, const std::string f ) {
    Cache &cache = cache::Global::get(); // FIXME?
    std::set< ept::debtags::Tag > t;
    t = cache.tags().tags( f );
    for (std::set< ept::debtags::Tag >::iterator i = t.begin(); i != t.end(); ++ i) {
        c->insertItem( i->name() );
    }
}

EasyTagFilterWidget::EasyTagFilterWidget( TQWidget *parent, const char *name )
    : EasyTagFilterUi( parent, name )
{
    fillCombo( m_use, "use" );
    fillCombo( m_interface, "interface" );
    fillCombo( m_worksWith, "works-with" );
    fillCombo( m_role, "role" );
    connect( m_use, TQT_SIGNAL( activated( int ) ),
             this, TQT_SLOT( widgetsChanged() ) );
    connect( m_interface, TQT_SIGNAL( activated( int ) ),
             this, TQT_SLOT( widgetsChanged() ) );
    connect( m_worksWith, TQT_SIGNAL( activated( int ) ),
             this, TQT_SLOT( widgetsChanged() ) );
    connect( m_role, TQT_SIGNAL( activated( int ) ),
             this, TQT_SLOT( widgetsChanged() ) );
    connect( m_reset, TQT_SIGNAL( clicked() ),
             this, TQT_SLOT( reset() ) );
}

static void setFacet( TQComboBox *c, const std::string fac,
                      EasyTagFilter< entity::Package > &f )
{
    if (c->currentItem())
        f.set( fac, c->currentText().ascii() );
}

EasyTagFilterWidget::Predicate EasyTagFilterWidget::predicate()
{
    EasyTagFilter< entity::Package > f;
    setFacet( m_use, "use", f );
    setFacet( m_interface, "interface", f );
    setFacet( m_worksWith, "works-with", f );
    setFacet( m_role, "role", f );
    return predicate::adapt< entity::Entity >( f );
}

static void setCombo( TQComboBox *c, const std::string &t ) {
    c->blockSignals( true );
    if (t == "")
        c->setCurrentItem( 0 );
    else
        c->setCurrentText( t );
    c->blockSignals( false );
}

void EasyTagFilterWidget::predicateChanged() {
    typedef EasyTagFilter< entity::Package > F;
    F f = downcast< F >( m_pred );
    setCombo( m_use, f.get( "use" ) );
    setCombo( m_interface, f.get( "interface" ) );
    setCombo( m_role, f.get( "role" ) );
    setCombo( m_worksWith, f.get( "works-with" ) );
}

void EasyTagFilterWidget::reset() {
    setCombo( m_use, "" );
    setCombo( m_interface, "" );
    setCombo( m_role, "" );
    setCombo( m_worksWith, "" );
    emit widgetsChanged();
}
