/** -*- C++ -*-
	@file adept/dpkgpm-gui.h
	@author Peter Rockai <me@mornfall.net>
*/

#ifndef EPT_DPKGPM_H
#  define EPT_DPKGPM_H

#include <apt-pkg/debsystem.h>
#include <adept/dpkgpm.h>
#include <kde_terminal_interface.h>
#include <kprocess.h>
#include <kdialogbase.h>

class KListBox;
namespace KParts {
class Part;
}

namespace adept {

class PkgSystem : public TQObject, public debSystem
{
    Q_OBJECT
  TQ_OBJECT
public:
    PkgSystem ();
    virtual pkgPackageManager *CreatePM( pkgDepCache *Cache ) const;
    virtual void setTerminal( KParts::Part *t );
    KParts::Part *terminal() { return m_terminalPart; }
    virtual int Score( Configuration const &Cnf ) {
        return debSystem::Score (Cnf) + 2; };
protected:
    KParts::Part *m_terminalPart;
signals:
    void statusChanged( int p, TQString m );
};

class DPkgPM : public TQObject, public aptFront::DPkgPM
{
    Q_OBJECT
  TQ_OBJECT
public:
    DPkgPM (pkgDepCache *c, KParts::Part *t);
    virtual bool forkDpkg (char *const argv[]);
    virtual void dpkgMonitor (void);
    virtual bool Go (int);
    virtual bool forkScript (const char *, bool);
    ExtTerminalInterface *terminal();
    virtual void updateStatus( std::string pkg, std::string ev, std::string r );
 
public slots:
    void processExitC(const KProcess *p);
    void processExit(KProcess *p);
    void setupScriptPipe();
    void setupDpkgChild();

signals:
    void statusChanged( int p, TQString m );

protected:
    KParts::Part *m_terminalPart;
    // DPkgProgress *m_prog;
            bool m_processRunning:1;
    const KProcess *m_exitedProcess;
};

}

#endif
