/** -*- C++ -*-
    @file adept/desktoplist.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <tqimage.h>
#include <klocale.h>

#include <apt-front/cache/entity/desktop.h>
#include <adept/extendablelist.h>
#include <adept/desktopentryui.h>

#ifndef EPT_DESKTOPLIST_H
#define EPT_DESKTOPLIST_H

class TQPopupMenu;

namespace adept {
using namespace aptFront;
using namespace aptFront::cache;

class DesktopItem;

class DesktopList : public ExtendableList, public cache::Observer
{
    Q_OBJECT
  TQ_OBJECT
public:
    typedef utils::Range< entity::Desktop > Range;
    DesktopList( TQWidget *parent = 0, const char *name = 0 );
    void insertRange( Range );
    TQPixmap emptyIcon() { return m_emptyIcon; }
    void polishing();
    void polished();

    void setTitle( TQString s ) {
        setColumnText( 0, i18n( "Application (" ) + s + i18n( ")" ) );
    }

    void setDisplayCheckboxes( bool d ) { m_displayCheckboxes = d; }
    bool displayCheckboxes() { return m_displayCheckboxes; }
    virtual void notifyPostChange( cache::component::Base * );
    void fireRequest( entity::Package p, component::State::Action a ) {
        emit request( p, a );
    }
protected slots:
    void processClick( TQListViewItem *, const TQPoint &, int );
signals:
    void request( cache::entity::Package, cache::component::State::Action );
    void showDescription( cache::entity::Desktop );
protected:
    Range m_range;
    TQPixmap m_emptyIcon;
    int m_polishing;
    bool m_displayCheckboxes;
};

class DesktopEntry : public DesktopEntryUi
{
    Q_OBJECT
  TQ_OBJECT
public:
    DesktopEntry( TQWidget * = 0, const char * = 0 );
    DesktopItem *item() const;
    entity::Desktop entity() const;
    void setItem( ExtendableItem * );
    entity::Package package() { return entity().package(); }
    virtual void notifyPostChange();
    virtual void resize( int, int );
    // virtual void polish();
public slots:
    void toggled();
protected:
    virtual void mousePressEvent( TQMouseEvent *e );
    virtual void mouseReleaseEvent( TQMouseEvent *e );
    virtual void showEvent( TQShowEvent * );
    bool m_polished;
};

class DesktopItem : public ExtendableItem
{
public:
    ItemExtender *createExtender();
    DesktopItem( DesktopList *l ) 
        : ExtendableItem( l ), m_delayedDone( false )
    {
    }
    DesktopItem( DesktopList *v, DesktopItem *i )
        : ExtendableItem( v, i ), m_delayedDone( false )
    {
    }

    void setup() {
        ExtendableItem::setup();
        if (m_delayedDone)
            return;
        m_delayedDone = true;
        showExtender();
    }

    DesktopList *list() { return dynamic_cast< DesktopList * >( listView() ); }

    TQString text( int ) const { return TQString( "you shouldn't see this" ); }
    entity::Desktop entity() const { return m_entity; }
    void setEntity( entity::Desktop e ) { m_entity = e; }

    virtual bool less( const ExtendableItem *other ) const {
        const DesktopItem *o = dynamic_cast< const DesktopItem * >( other );
        return entity() < o->entity();
    }

protected:
    entity::Desktop m_entity;
    bool m_delayedDone:1;
};

}

#endif
