/* -*- C++ -*- */
#ifndef CHANGELOG_H
#define CHANGELOG_H

#include <tqobject.h>
#include <tqstring.h>
#include <tqhttp.h>
#include <tqbuffer.h>

#include <adept/lister.h>

#ifdef Q_MOC_RUN
#define KUBUNTU
#endif

#ifdef KUBUNTU
#define BASE_CHANGELOG_HOST "changelogs.ubuntu.com"
#define BASE_CHANGELOG_PORT 80
#define BASE_CHANGELOG_URL "/changelogs/pool"

namespace adept {

  class ItemChangelog : public TQObject {
  Q_OBJECT
  TQ_OBJECT
  public:
    ItemChangelog();
    ~ItemChangelog();

    // Give me the changelog's URL
    TQString changelogUrl();
    void setParent(entity::Package parent) { m_pkg = parent; }
  signals:
    void changelogNeeded();
    void changelogReady(TQString content);

  protected slots:
    // Give me the changelog's text
    void requestChangelog();
    void contentReady(int id, bool error);

  protected:
    entity::Package m_pkg;
    TQHttp* m_http;
    TQBuffer* m_content_catcher;
  };
}

#endif /* KUBUNTU */
#endif /*CHANGELOG_H*/
