#!/bin/sh

echo "\"Detektive\" investigates your system and tries to list missing packages."
echo

mandrake()
{
  file="/etc/mandrake-release"
  if [ ! "`grep 9.1 $file`" = "" ]; then
    echo "Detected Mandrake 9.1 as distribution."
    rpm_list="mandrake-91.lst"
  elif [ ! "`grep 9.2 $file`" = "" ]; then
    echo "Detected Mandrake 9.2 as distribution."
    rpm_list="mandrake-92.lst"
  elif [ ! "`grep 10.1 $file`" = "" ]; then
    echo "Detected Mandrake 10.1 as distribution."
    rpm_list="mandrake-101.lst"
  else
    echo "Detected unsupported Mandrake distribution."
    exit
  fi
}

suse()
{
  file="/etc/SuSE-release"
  if [ ! "`grep 8.1 $file`" = "" ]; then
    echo "Detected SuSE 8.1 as distribution."
    rpm_list="suse-81.lst"
  elif [ ! "`grep 8.2 $file`" = "" ]; then
    echo "Detected SuSE 8.2 as distribution."
    rpm_list="suse-82.lst"
  elif [ ! "`grep 9.0 $file`" = "" ]; then
    echo "Detected SuSE 9.0 as distribution."
    rpm_list="suse-90.lst"
  elif [ ! "`grep 9.1 $file`" = "" ]; then
    echo "Detected SuSE 9.1 as distribution."
    rpm_list="suse-91.lst"
  elif [ ! "`grep 9.2 $file`" = "" ]; then
    echo "Detected SuSE 9.2 as distribution."
    rpm_list="suse-92.lst"
  else
    echo "Detected unsupported SuSE distribution."
  fi
}

if [ -f /etc/mandrake-release ]; then
  mandrake
elif [ -f /etc/SuSE-release ]; then
  suse
elif [ -f /etc/redhat-release ]; then
  echo "Detected unsupported RedHat distribution."
  exit
fi

if [ -z $rpm_list ]; then
  echo "No supported distribution detected."
else
  echo
  echo "Checking for known uninstalled rpm packages which may be missing:"

  cat $rpm_list | \
  while read package_file necessity comment;
    do rpm -q -i $package_file 2>/dev/null >/dev/null;
    if [ $? = "1" ]; then
      echo " Package: $package_file ($necessity)";
      if [ -n "$comment" ]; then
        echo "  $comment";
      fi;
    fi;
  done;

  echo
  echo "If you have installed these from source you may ignore this list."
fi
