/***************************************************************************
 *
 * knetworkmanager-vpnc.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 * Author: Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPNC_H
#define KNETWORKMANAGER_VPNC_H

#include <tqmap.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqlayout.h>

#include "knetworkmanager-vpnplugin.h"
#include "vpncprop.h"
#include "vpncauth.h"

class VPNCPlugin : public VPNPlugin
{
	Q_OBJECT
	public:
		VPNCPlugin(TQObject*, const char*, const TQStringList&);
		~VPNCPlugin();

		VPNConfigWidget* CreateConfigWidget(TQWidget* parent=0);
		VPNAuthenticationWidget* CreateAuthenticationWidget(TQWidget* parent=0);
};

class VPNCConfig : public VPNConfigWidget
{
	Q_OBJECT
	public:
		void setVPNData(const TQStringList& routes, const TQMap<TQString, TQString>& properties);
		TQMap<TQString, TQString> getVPNProperties();
		TQStringList getVPNRoutes();
		bool hasChanged();
		bool isValid(TQStringList& );

		VPNCConfig(TQWidget* parent);
		~VPNCConfig();

	public slots:
		void pcfImport();

	private:
		VPNCConfigWidget*   _vpncWidget;
		int getFileConfig(char *parameter, char *line);

	protected slots:
		void languageChange();
};

class VPNCAuthentication : public VPNAuthenticationWidget
{
	Q_OBJECT
	public:
		VPNCAuthentication(TQWidget* parent = NULL, char* name = NULL);
		~VPNCAuthentication();
		TQMap<TQString, TQString> getPasswords();
		void setPasswords(TQString name, TQString value);

	private:
		VPNCAuthenticationWidget* _vpncAuth;
};

#endif /* KNETWORKMANAGER_VPNC_H */
